"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.trimUserFormData = exports.getOwnerDefaultValue = exports.getInitialCaseValue = exports.createFormSerializer = exports.createFormDeserializer = void 0;
var _lodash = require("lodash");
var _common = require("../../../common");
var _domain = require("../../../common/types/domain");
var _utils = require("../configure_cases/utils");
var _utils2 = require("../utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getInitialCaseValue = ({
  owner,
  connector,
  ...restFields
}) => ({
  title: '',
  assignees: [],
  tags: [],
  category: undefined,
  severity: _domain.CaseSeverity.LOW,
  description: '',
  settings: {
    syncAlerts: true,
    extractObservables: true
  },
  customFields: [],
  ...restFields,
  connector: connector !== null && connector !== void 0 ? connector : (0, _utils.getNoneConnector)(),
  owner
});
exports.getInitialCaseValue = getInitialCaseValue;
const trimUserFormData = userFormData => {
  let formData = {
    ...userFormData,
    title: userFormData.title.trim(),
    description: userFormData.description.trim()
  };
  if (userFormData.category) {
    formData = {
      ...formData,
      category: userFormData.category.trim()
    };
  }
  if (userFormData.tags) {
    formData = {
      ...formData,
      tags: userFormData.tags.map(tag => tag.trim())
    };
  }
  return formData;
};
exports.trimUserFormData = trimUserFormData;
const createFormDeserializer = data => {
  var _settings$extractObse, _customFieldsFormDese;
  const {
    connector,
    settings,
    customFields,
    ...restData
  } = data;
  return {
    ...restData,
    connectorId: connector.id,
    fields: connector.fields,
    syncAlerts: settings.syncAlerts,
    extractObservables: (_settings$extractObse = settings.extractObservables) !== null && _settings$extractObse !== void 0 ? _settings$extractObse : false,
    customFields: (_customFieldsFormDese = (0, _utils2.customFieldsFormDeserializer)(customFields)) !== null && _customFieldsFormDese !== void 0 ? _customFieldsFormDese : {}
  };
};
exports.createFormDeserializer = createFormDeserializer;
const createFormSerializer = (connectors, currentConfiguration, data) => {
  if (data == null || (0, _lodash.isEmpty)(data)) {
    return getInitialCaseValue({
      owner: currentConfiguration.owner,
      connector: currentConfiguration.connector
    });
  }
  const {
    connectorId: dataConnectorId,
    fields,
    syncAlerts,
    extractObservables,
    customFields,
    ...restData
  } = data;
  const serializedConnectorFields = (0, _utils2.getConnectorsFormSerializer)({
    fields
  });
  const caseConnector = (0, _utils2.getConnectorById)(dataConnectorId, connectors);
  const connectorToUpdate = caseConnector ? (0, _utils.normalizeActionConnector)(caseConnector, serializedConnectorFields.fields) : (0, _utils.getNoneConnector)();
  const transformedCustomFields = (0, _utils2.customFieldsFormSerializer)(customFields, currentConfiguration.customFields);
  const trimmedData = trimUserFormData(restData);
  return {
    ...trimmedData,
    connector: connectorToUpdate,
    settings: {
      syncAlerts: syncAlerts !== null && syncAlerts !== void 0 ? syncAlerts : false,
      extractObservables: extractObservables !== null && extractObservables !== void 0 ? extractObservables : false
    },
    owner: currentConfiguration.owner,
    customFields: transformedCustomFields
  };
};
exports.createFormSerializer = createFormSerializer;
const getOwnerDefaultValue = availableOwners => {
  var _availableOwners$;
  return availableOwners.includes(_common.GENERAL_CASES_OWNER) ? _common.GENERAL_CASES_OWNER : (_availableOwners$ = availableOwners[0]) !== null && _availableOwners$ !== void 0 ? _availableOwners$ : _common.GENERAL_CASES_OWNER;
};
exports.getOwnerDefaultValue = getOwnerDefaultValue;