"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  DEFAULT_DATE_FORMAT: true,
  DEFAULT_DATE_FORMAT_TZ: true,
  CASE_SAVED_OBJECT: true,
  CASE_CONNECTOR_MAPPINGS_SAVED_OBJECT: true,
  CASE_USER_ACTION_SAVED_OBJECT: true,
  CASE_COMMENT_SAVED_OBJECT: true,
  CASE_CONFIGURE_SAVED_OBJECT: true,
  CASE_RULES_SAVED_OBJECT: true,
  CASE_ID_INCREMENTER_SAVED_OBJECT: true,
  SAVED_OBJECT_TYPES: true,
  CASES_URL: true,
  CASE_FIND_URL: true,
  CASE_DETAILS_URL: true,
  CASE_CONFIGURE_URL: true,
  CASE_CONFIGURE_DETAILS_URL: true,
  CASE_CONFIGURE_CONNECTORS_URL: true,
  CASE_COMMENTS_URL: true,
  CASE_FIND_ATTACHMENTS_URL: true,
  CASE_COMMENT_DETAILS_URL: true,
  CASE_COMMENT_DELETE_URL: true,
  CASE_PUSH_URL: true,
  CASE_REPORTERS_URL: true,
  CASE_TAGS_URL: true,
  CASE_USER_ACTIONS_URL: true,
  CASE_FIND_USER_ACTIONS_URL: true,
  CASE_ALERTS_URL: true,
  CASE_DETAILS_ALERTS_URL: true,
  CASE_FILES_URL: true,
  CASES_INTERNAL_URL: true,
  INTERNAL_BULK_CREATE_ATTACHMENTS_URL: true,
  INTERNAL_BULK_GET_ATTACHMENTS_URL: true,
  INTERNAL_SUGGEST_USER_PROFILES_URL: true,
  INTERNAL_CONNECTORS_URL: true,
  INTERNAL_BULK_GET_CASES_URL: true,
  INTERNAL_GET_CASE_USER_ACTIONS_STATS_URL: true,
  INTERNAL_CASE_USERS_URL: true,
  INTERNAL_DELETE_FILE_ATTACHMENTS_URL: true,
  INTERNAL_GET_CASE_CATEGORIES_URL: true,
  INTERNAL_CASE_METRICS_URL: true,
  INTERNAL_CASE_METRICS_DETAILS_URL: true,
  INTERNAL_CASE_SIMILAR_CASES_URL: true,
  INTERNAL_PUT_CUSTOM_FIELDS_URL: true,
  INTERNAL_CASE_OBSERVABLES_URL: true,
  INTERNAL_CASE_OBSERVABLES_PATCH_URL: true,
  INTERNAL_CASE_OBSERVABLES_DELETE_URL: true,
  INTERNAL_CASE_FIND_USER_ACTIONS_URL: true,
  INTERNAL_CASE_GET_CASES_BY_ATTACHMENT_URL: true,
  INTERNAL_BULK_CREATE_CASE_OBSERVABLES_URL: true,
  ACTION_URL: true,
  ACTION_TYPES_URL: true,
  CONNECTORS_URL: true,
  MAX_ALERTS_PER_CASE: true,
  MAX_DOCS_PER_PAGE: true,
  MAX_BULK_GET_ATTACHMENTS: true,
  MAX_CONCURRENT_SEARCHES: true,
  MAX_BULK_GET_CASES: true,
  MAX_COMMENTS_PER_PAGE: true,
  MAX_CASES_PER_PAGE: true,
  MAX_USER_ACTIONS_PER_PAGE: true,
  MAX_CATEGORY_FILTER_LENGTH: true,
  MAX_TAGS_FILTER_LENGTH: true,
  MAX_ASSIGNEES_FILTER_LENGTH: true,
  MAX_REPORTERS_FILTER_LENGTH: true,
  MAX_SUPPORTED_CONNECTORS_RETURNED: true,
  MAX_TITLE_LENGTH: true,
  MAX_RULE_NAME_LENGTH: true,
  MAX_SUFFIX_LENGTH: true,
  MAX_CATEGORY_LENGTH: true,
  MAX_DESCRIPTION_LENGTH: true,
  MAX_COMMENT_LENGTH: true,
  MAX_LENGTH_PER_TAG: true,
  MAX_TAGS_PER_CASE: true,
  MAX_DELETE_IDS_LENGTH: true,
  MAX_SUGGESTED_PROFILES: true,
  MAX_CASES_TO_UPDATE: true,
  MAX_BULK_CREATE_ATTACHMENTS: true,
  MAX_USER_ACTIONS_PER_CASE: true,
  MAX_PERSISTABLE_STATE_AND_EXTERNAL_REFERENCES: true,
  MAX_CUSTOM_FIELDS_PER_CASE: true,
  MAX_CUSTOM_FIELD_KEY_LENGTH: true,
  MAX_CUSTOM_FIELD_LABEL_LENGTH: true,
  MAX_CUSTOM_FIELD_TEXT_VALUE_LENGTH: true,
  MAX_TEMPLATE_KEY_LENGTH: true,
  MAX_TEMPLATE_NAME_LENGTH: true,
  MAX_TEMPLATE_DESCRIPTION_LENGTH: true,
  MAX_TEMPLATES_LENGTH: true,
  MAX_TEMPLATE_TAG_LENGTH: true,
  MAX_TAGS_PER_TEMPLATE: true,
  MAX_FILENAME_LENGTH: true,
  MAX_CUSTOM_OBSERVABLE_TYPES_LABEL_LENGTH: true,
  DEFAULT_FEATURES: true,
  CASES_TELEMETRY_TASK_NAME: true,
  ANALYTICS_BACKFILL_TASK_TYPE: true,
  ANALYTICS_SCHEDULER_TASK_TYPE: true,
  ANALYTICS_SYNCHRONIZATION_TASK_TYPE: true,
  CASE_TELEMETRY_SAVED_OBJECT: true,
  CASE_TELEMETRY_SAVED_OBJECT_ID: true,
  CREATE_CASES_CAPABILITY: true,
  READ_CASES_CAPABILITY: true,
  UPDATE_CASES_CAPABILITY: true,
  DELETE_CASES_CAPABILITY: true,
  PUSH_CASES_CAPABILITY: true,
  CASES_SETTINGS_CAPABILITY: true,
  CASES_CONNECTORS_CAPABILITY: true,
  CASES_REOPEN_CAPABILITY: true,
  CREATE_COMMENT_CAPABILITY: true,
  ASSIGN_CASE_CAPABILITY: true,
  SUGGEST_USER_PROFILES_API_TAG: true,
  BULK_GET_USER_PROFILES_API_TAG: true,
  GET_CONNECTORS_CONFIGURE_API_TAG: true,
  DEFAULT_USER_SIZE: true,
  MAX_ASSIGNEES_PER_CASE: true,
  NO_ASSIGNEES_FILTERING_KEYWORD: true,
  KIBANA_SYSTEM_USERNAME: true,
  MAX_OBSERVABLES_PER_CASE: true,
  SEARCH_DEBOUNCE_MS: true,
  LOCAL_STORAGE_KEYS: true,
  CASES_CONNECTOR_SUB_ACTION: true,
  NONE_CONNECTOR_ID: true,
  CASES_CONNECTOR_ID: true,
  CASES_CONNECTOR_TITLE: true,
  CASES_CONNECTOR_TIME_WINDOW_REGEX: true,
  OWNER_FIELD: true,
  MAX_OBSERVABLE_TYPE_KEY_LENGTH: true,
  MAX_OBSERVABLE_TYPE_LABEL_LENGTH: true,
  MAX_CUSTOM_OBSERVABLE_TYPES: true,
  CASE_PAGE_VIEW_EVENT_TYPE: true,
  LENS_ATTACHMENT_TYPE: true
};
exports.KIBANA_SYSTEM_USERNAME = exports.INTERNAL_SUGGEST_USER_PROFILES_URL = exports.INTERNAL_PUT_CUSTOM_FIELDS_URL = exports.INTERNAL_GET_CASE_USER_ACTIONS_STATS_URL = exports.INTERNAL_GET_CASE_CATEGORIES_URL = exports.INTERNAL_DELETE_FILE_ATTACHMENTS_URL = exports.INTERNAL_CONNECTORS_URL = exports.INTERNAL_CASE_USERS_URL = exports.INTERNAL_CASE_SIMILAR_CASES_URL = exports.INTERNAL_CASE_OBSERVABLES_URL = exports.INTERNAL_CASE_OBSERVABLES_PATCH_URL = exports.INTERNAL_CASE_OBSERVABLES_DELETE_URL = exports.INTERNAL_CASE_METRICS_URL = exports.INTERNAL_CASE_METRICS_DETAILS_URL = exports.INTERNAL_CASE_GET_CASES_BY_ATTACHMENT_URL = exports.INTERNAL_CASE_FIND_USER_ACTIONS_URL = exports.INTERNAL_BULK_GET_CASES_URL = exports.INTERNAL_BULK_GET_ATTACHMENTS_URL = exports.INTERNAL_BULK_CREATE_CASE_OBSERVABLES_URL = exports.INTERNAL_BULK_CREATE_ATTACHMENTS_URL = exports.GET_CONNECTORS_CONFIGURE_API_TAG = exports.DELETE_CASES_CAPABILITY = exports.DEFAULT_USER_SIZE = exports.DEFAULT_FEATURES = exports.DEFAULT_DATE_FORMAT_TZ = exports.DEFAULT_DATE_FORMAT = exports.CREATE_COMMENT_CAPABILITY = exports.CREATE_CASES_CAPABILITY = exports.CONNECTORS_URL = exports.CASE_USER_ACTION_SAVED_OBJECT = exports.CASE_USER_ACTIONS_URL = exports.CASE_TELEMETRY_SAVED_OBJECT_ID = exports.CASE_TELEMETRY_SAVED_OBJECT = exports.CASE_TAGS_URL = exports.CASE_SAVED_OBJECT = exports.CASE_RULES_SAVED_OBJECT = exports.CASE_REPORTERS_URL = exports.CASE_PUSH_URL = exports.CASE_PAGE_VIEW_EVENT_TYPE = exports.CASE_ID_INCREMENTER_SAVED_OBJECT = exports.CASE_FIND_USER_ACTIONS_URL = exports.CASE_FIND_URL = exports.CASE_FIND_ATTACHMENTS_URL = exports.CASE_FILES_URL = exports.CASE_DETAILS_URL = exports.CASE_DETAILS_ALERTS_URL = exports.CASE_CONNECTOR_MAPPINGS_SAVED_OBJECT = exports.CASE_CONFIGURE_URL = exports.CASE_CONFIGURE_SAVED_OBJECT = exports.CASE_CONFIGURE_DETAILS_URL = exports.CASE_CONFIGURE_CONNECTORS_URL = exports.CASE_COMMENT_SAVED_OBJECT = exports.CASE_COMMENT_DETAILS_URL = exports.CASE_COMMENT_DELETE_URL = exports.CASE_COMMENTS_URL = exports.CASE_ALERTS_URL = exports.CASES_URL = exports.CASES_TELEMETRY_TASK_NAME = exports.CASES_SETTINGS_CAPABILITY = exports.CASES_REOPEN_CAPABILITY = exports.CASES_INTERNAL_URL = exports.CASES_CONNECTOR_TITLE = exports.CASES_CONNECTOR_TIME_WINDOW_REGEX = exports.CASES_CONNECTOR_SUB_ACTION = exports.CASES_CONNECTOR_ID = exports.CASES_CONNECTORS_CAPABILITY = exports.BULK_GET_USER_PROFILES_API_TAG = exports.ASSIGN_CASE_CAPABILITY = exports.ANALYTICS_SYNCHRONIZATION_TASK_TYPE = exports.ANALYTICS_SCHEDULER_TASK_TYPE = exports.ANALYTICS_BACKFILL_TASK_TYPE = exports.ACTION_URL = exports.ACTION_TYPES_URL = void 0;
Object.defineProperty(exports, "LENS_ATTACHMENT_TYPE", {
  enumerable: true,
  get: function () {
    return _visualizations.LENS_ATTACHMENT_TYPE;
  }
});
exports.MAX_OBSERVABLES_PER_CASE = exports.MAX_LENGTH_PER_TAG = exports.MAX_FILENAME_LENGTH = exports.MAX_DOCS_PER_PAGE = exports.MAX_DESCRIPTION_LENGTH = exports.MAX_DELETE_IDS_LENGTH = exports.MAX_CUSTOM_OBSERVABLE_TYPES_LABEL_LENGTH = exports.MAX_CUSTOM_OBSERVABLE_TYPES = exports.MAX_CUSTOM_FIELD_TEXT_VALUE_LENGTH = exports.MAX_CUSTOM_FIELD_LABEL_LENGTH = exports.MAX_CUSTOM_FIELD_KEY_LENGTH = exports.MAX_CUSTOM_FIELDS_PER_CASE = exports.MAX_CONCURRENT_SEARCHES = exports.MAX_COMMENT_LENGTH = exports.MAX_COMMENTS_PER_PAGE = exports.MAX_CATEGORY_LENGTH = exports.MAX_CATEGORY_FILTER_LENGTH = exports.MAX_CASES_TO_UPDATE = exports.MAX_CASES_PER_PAGE = exports.MAX_BULK_GET_CASES = exports.MAX_BULK_GET_ATTACHMENTS = exports.MAX_BULK_CREATE_ATTACHMENTS = exports.MAX_ASSIGNEES_PER_CASE = exports.MAX_ASSIGNEES_FILTER_LENGTH = exports.MAX_ALERTS_PER_CASE = exports.LOCAL_STORAGE_KEYS = void 0;
exports.UPDATE_CASES_CAPABILITY = exports.SUGGEST_USER_PROFILES_API_TAG = exports.SEARCH_DEBOUNCE_MS = exports.SAVED_OBJECT_TYPES = exports.READ_CASES_CAPABILITY = exports.PUSH_CASES_CAPABILITY = exports.OWNER_FIELD = exports.NO_ASSIGNEES_FILTERING_KEYWORD = exports.NONE_CONNECTOR_ID = exports.MAX_USER_ACTIONS_PER_PAGE = exports.MAX_USER_ACTIONS_PER_CASE = exports.MAX_TITLE_LENGTH = exports.MAX_TEMPLATE_TAG_LENGTH = exports.MAX_TEMPLATE_NAME_LENGTH = exports.MAX_TEMPLATE_KEY_LENGTH = exports.MAX_TEMPLATE_DESCRIPTION_LENGTH = exports.MAX_TEMPLATES_LENGTH = exports.MAX_TAGS_PER_TEMPLATE = exports.MAX_TAGS_PER_CASE = exports.MAX_TAGS_FILTER_LENGTH = exports.MAX_SUPPORTED_CONNECTORS_RETURNED = exports.MAX_SUGGESTED_PROFILES = exports.MAX_SUFFIX_LENGTH = exports.MAX_RULE_NAME_LENGTH = exports.MAX_REPORTERS_FILTER_LENGTH = exports.MAX_PERSISTABLE_STATE_AND_EXTERNAL_REFERENCES = exports.MAX_OBSERVABLE_TYPE_LABEL_LENGTH = exports.MAX_OBSERVABLE_TYPE_KEY_LENGTH = void 0;
var _owners = require("./owners");
Object.keys(_owners).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _owners[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _owners[key];
    }
  });
});
var _files = require("./files");
Object.keys(_files).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _files[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _files[key];
    }
  });
});
var _application = require("./application");
Object.keys(_application).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _application[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _application[key];
    }
  });
});
var _observables = require("./observables");
Object.keys(_observables).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _observables[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _observables[key];
    }
  });
});
var _visualizations = require("./visualizations");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const DEFAULT_DATE_FORMAT = exports.DEFAULT_DATE_FORMAT = 'dateFormat';
const DEFAULT_DATE_FORMAT_TZ = exports.DEFAULT_DATE_FORMAT_TZ = 'dateFormat:tz';

/**
 * Saved objects
 */

const CASE_SAVED_OBJECT = exports.CASE_SAVED_OBJECT = 'cases';
const CASE_CONNECTOR_MAPPINGS_SAVED_OBJECT = exports.CASE_CONNECTOR_MAPPINGS_SAVED_OBJECT = 'cases-connector-mappings';
const CASE_USER_ACTION_SAVED_OBJECT = exports.CASE_USER_ACTION_SAVED_OBJECT = 'cases-user-actions';
const CASE_COMMENT_SAVED_OBJECT = exports.CASE_COMMENT_SAVED_OBJECT = 'cases-comments';
const CASE_CONFIGURE_SAVED_OBJECT = exports.CASE_CONFIGURE_SAVED_OBJECT = 'cases-configure';
const CASE_RULES_SAVED_OBJECT = exports.CASE_RULES_SAVED_OBJECT = 'cases-rules';
const CASE_ID_INCREMENTER_SAVED_OBJECT = exports.CASE_ID_INCREMENTER_SAVED_OBJECT = 'cases-incrementing-id';

/**
 * If more values are added here please also add them here: x-pack/test/cases_api_integration/common/plugins
 */
const SAVED_OBJECT_TYPES = exports.SAVED_OBJECT_TYPES = [CASE_SAVED_OBJECT, CASE_CONNECTOR_MAPPINGS_SAVED_OBJECT, CASE_USER_ACTION_SAVED_OBJECT, CASE_COMMENT_SAVED_OBJECT, CASE_CONFIGURE_SAVED_OBJECT];

/**
 * Case routes
 */

const CASES_URL = exports.CASES_URL = '/api/cases';
const CASE_FIND_URL = exports.CASE_FIND_URL = `${CASES_URL}/_find`;
const CASE_DETAILS_URL = exports.CASE_DETAILS_URL = `${CASES_URL}/{case_id}`;
const CASE_CONFIGURE_URL = exports.CASE_CONFIGURE_URL = `${CASES_URL}/configure`;
const CASE_CONFIGURE_DETAILS_URL = exports.CASE_CONFIGURE_DETAILS_URL = `${CASES_URL}/configure/{configuration_id}`;
const CASE_CONFIGURE_CONNECTORS_URL = exports.CASE_CONFIGURE_CONNECTORS_URL = `${CASE_CONFIGURE_URL}/connectors`;
const CASE_COMMENTS_URL = exports.CASE_COMMENTS_URL = `${CASE_DETAILS_URL}/comments`;
const CASE_FIND_ATTACHMENTS_URL = exports.CASE_FIND_ATTACHMENTS_URL = `${CASE_COMMENTS_URL}/_find`;
const CASE_COMMENT_DETAILS_URL = exports.CASE_COMMENT_DETAILS_URL = `${CASE_DETAILS_URL}/comments/{comment_id}`;
const CASE_COMMENT_DELETE_URL = exports.CASE_COMMENT_DELETE_URL = `${CASE_DETAILS_URL}/comments/{comment_id}`;
const CASE_PUSH_URL = exports.CASE_PUSH_URL = `${CASE_DETAILS_URL}/connector/{connector_id}/_push`;
const CASE_REPORTERS_URL = exports.CASE_REPORTERS_URL = `${CASES_URL}/reporters`;
const CASE_TAGS_URL = exports.CASE_TAGS_URL = `${CASES_URL}/tags`;
const CASE_USER_ACTIONS_URL = exports.CASE_USER_ACTIONS_URL = `${CASE_DETAILS_URL}/user_actions`;
const CASE_FIND_USER_ACTIONS_URL = exports.CASE_FIND_USER_ACTIONS_URL = `${CASE_USER_ACTIONS_URL}/_find`;
const CASE_ALERTS_URL = exports.CASE_ALERTS_URL = `${CASES_URL}/alerts/{alert_id}`;
const CASE_DETAILS_ALERTS_URL = exports.CASE_DETAILS_ALERTS_URL = `${CASE_DETAILS_URL}/alerts`;
const CASE_FILES_URL = exports.CASE_FILES_URL = `${CASE_DETAILS_URL}/files`;

/**
 * Internal routes
 */

const CASES_INTERNAL_URL = exports.CASES_INTERNAL_URL = '/internal/cases';
const INTERNAL_BULK_CREATE_ATTACHMENTS_URL = exports.INTERNAL_BULK_CREATE_ATTACHMENTS_URL = `${CASES_INTERNAL_URL}/{case_id}/attachments/_bulk_create`;
const INTERNAL_BULK_GET_ATTACHMENTS_URL = exports.INTERNAL_BULK_GET_ATTACHMENTS_URL = `${CASES_INTERNAL_URL}/{case_id}/attachments/_bulk_get`;
const INTERNAL_SUGGEST_USER_PROFILES_URL = exports.INTERNAL_SUGGEST_USER_PROFILES_URL = `${CASES_INTERNAL_URL}/_suggest_user_profiles`;
const INTERNAL_CONNECTORS_URL = exports.INTERNAL_CONNECTORS_URL = `${CASES_INTERNAL_URL}/{case_id}/_connectors`;
const INTERNAL_BULK_GET_CASES_URL = exports.INTERNAL_BULK_GET_CASES_URL = `${CASES_INTERNAL_URL}/_bulk_get`;
const INTERNAL_GET_CASE_USER_ACTIONS_STATS_URL = exports.INTERNAL_GET_CASE_USER_ACTIONS_STATS_URL = `${CASES_INTERNAL_URL}/{case_id}/user_actions/_stats`;
const INTERNAL_CASE_USERS_URL = exports.INTERNAL_CASE_USERS_URL = `${CASES_INTERNAL_URL}/{case_id}/_users`;
const INTERNAL_DELETE_FILE_ATTACHMENTS_URL = exports.INTERNAL_DELETE_FILE_ATTACHMENTS_URL = `${CASES_INTERNAL_URL}/{case_id}/attachments/files/_bulk_delete`;
const INTERNAL_GET_CASE_CATEGORIES_URL = exports.INTERNAL_GET_CASE_CATEGORIES_URL = `${CASES_INTERNAL_URL}/categories`;
const INTERNAL_CASE_METRICS_URL = exports.INTERNAL_CASE_METRICS_URL = `${CASES_INTERNAL_URL}/metrics`;
const INTERNAL_CASE_METRICS_DETAILS_URL = exports.INTERNAL_CASE_METRICS_DETAILS_URL = `${CASES_INTERNAL_URL}/metrics/{case_id}`;
const INTERNAL_CASE_SIMILAR_CASES_URL = exports.INTERNAL_CASE_SIMILAR_CASES_URL = `${CASES_INTERNAL_URL}/{case_id}/_similar`;
const INTERNAL_PUT_CUSTOM_FIELDS_URL = exports.INTERNAL_PUT_CUSTOM_FIELDS_URL = `${CASES_INTERNAL_URL}/{case_id}/custom_fields/{custom_field_id}`;
const INTERNAL_CASE_OBSERVABLES_URL = exports.INTERNAL_CASE_OBSERVABLES_URL = `${CASES_INTERNAL_URL}/{case_id}/observables`;
const INTERNAL_CASE_OBSERVABLES_PATCH_URL = exports.INTERNAL_CASE_OBSERVABLES_PATCH_URL = `${INTERNAL_CASE_OBSERVABLES_URL}/{observable_id}`;
const INTERNAL_CASE_OBSERVABLES_DELETE_URL = exports.INTERNAL_CASE_OBSERVABLES_DELETE_URL = `${INTERNAL_CASE_OBSERVABLES_URL}/{observable_id}`;
const INTERNAL_CASE_FIND_USER_ACTIONS_URL = exports.INTERNAL_CASE_FIND_USER_ACTIONS_URL = `${CASES_INTERNAL_URL}/{case_id}/user_actions/_find`;
const INTERNAL_CASE_GET_CASES_BY_ATTACHMENT_URL = exports.INTERNAL_CASE_GET_CASES_BY_ATTACHMENT_URL = `${CASES_INTERNAL_URL}/case/alerts/_find_containing_all`;
const INTERNAL_BULK_CREATE_CASE_OBSERVABLES_URL = exports.INTERNAL_BULK_CREATE_CASE_OBSERVABLES_URL = `${CASES_INTERNAL_URL}/{case_id}/observables/_bulk_create`;

/**
 * Action routes
 */

const ACTION_URL = exports.ACTION_URL = '/api/actions';
const ACTION_TYPES_URL = exports.ACTION_TYPES_URL = `${ACTION_URL}/connector_types`;
const CONNECTORS_URL = exports.CONNECTORS_URL = `${ACTION_URL}/connectors`;

/**
 * Alerts
 */
const MAX_ALERTS_PER_CASE = exports.MAX_ALERTS_PER_CASE = 1000;

/**
 * Searching
 */
const MAX_DOCS_PER_PAGE = exports.MAX_DOCS_PER_PAGE = 10000;
const MAX_BULK_GET_ATTACHMENTS = exports.MAX_BULK_GET_ATTACHMENTS = 100;
const MAX_CONCURRENT_SEARCHES = exports.MAX_CONCURRENT_SEARCHES = 10;
const MAX_BULK_GET_CASES = exports.MAX_BULK_GET_CASES = 1000;
const MAX_COMMENTS_PER_PAGE = exports.MAX_COMMENTS_PER_PAGE = 100;
const MAX_CASES_PER_PAGE = exports.MAX_CASES_PER_PAGE = 100;
const MAX_USER_ACTIONS_PER_PAGE = exports.MAX_USER_ACTIONS_PER_PAGE = 100;
const MAX_CATEGORY_FILTER_LENGTH = exports.MAX_CATEGORY_FILTER_LENGTH = 100;
const MAX_TAGS_FILTER_LENGTH = exports.MAX_TAGS_FILTER_LENGTH = 100;
const MAX_ASSIGNEES_FILTER_LENGTH = exports.MAX_ASSIGNEES_FILTER_LENGTH = 100;
const MAX_REPORTERS_FILTER_LENGTH = exports.MAX_REPORTERS_FILTER_LENGTH = 100;
const MAX_SUPPORTED_CONNECTORS_RETURNED = exports.MAX_SUPPORTED_CONNECTORS_RETURNED = 1000;

/**
 * Validation
 */

const MAX_TITLE_LENGTH = exports.MAX_TITLE_LENGTH = 160;
const MAX_RULE_NAME_LENGTH = exports.MAX_RULE_NAME_LENGTH = 100;
const MAX_SUFFIX_LENGTH = exports.MAX_SUFFIX_LENGTH = 60;
const MAX_CATEGORY_LENGTH = exports.MAX_CATEGORY_LENGTH = 50;
const MAX_DESCRIPTION_LENGTH = exports.MAX_DESCRIPTION_LENGTH = 30000;
const MAX_COMMENT_LENGTH = exports.MAX_COMMENT_LENGTH = 30000;
const MAX_LENGTH_PER_TAG = exports.MAX_LENGTH_PER_TAG = 256;
const MAX_TAGS_PER_CASE = exports.MAX_TAGS_PER_CASE = 200;
const MAX_DELETE_IDS_LENGTH = exports.MAX_DELETE_IDS_LENGTH = 100;
const MAX_SUGGESTED_PROFILES = exports.MAX_SUGGESTED_PROFILES = 10;
const MAX_CASES_TO_UPDATE = exports.MAX_CASES_TO_UPDATE = 100;
const MAX_BULK_CREATE_ATTACHMENTS = exports.MAX_BULK_CREATE_ATTACHMENTS = 100;
const MAX_USER_ACTIONS_PER_CASE = exports.MAX_USER_ACTIONS_PER_CASE = 10000;
const MAX_PERSISTABLE_STATE_AND_EXTERNAL_REFERENCES = exports.MAX_PERSISTABLE_STATE_AND_EXTERNAL_REFERENCES = 100;
const MAX_CUSTOM_FIELDS_PER_CASE = exports.MAX_CUSTOM_FIELDS_PER_CASE = 10;
const MAX_CUSTOM_FIELD_KEY_LENGTH = exports.MAX_CUSTOM_FIELD_KEY_LENGTH = 36; // uuidv4 length
const MAX_CUSTOM_FIELD_LABEL_LENGTH = exports.MAX_CUSTOM_FIELD_LABEL_LENGTH = 50;
const MAX_CUSTOM_FIELD_TEXT_VALUE_LENGTH = exports.MAX_CUSTOM_FIELD_TEXT_VALUE_LENGTH = 160;
const MAX_TEMPLATE_KEY_LENGTH = exports.MAX_TEMPLATE_KEY_LENGTH = 36; // uuidv4 length
const MAX_TEMPLATE_NAME_LENGTH = exports.MAX_TEMPLATE_NAME_LENGTH = 50;
const MAX_TEMPLATE_DESCRIPTION_LENGTH = exports.MAX_TEMPLATE_DESCRIPTION_LENGTH = 1000;
const MAX_TEMPLATES_LENGTH = exports.MAX_TEMPLATES_LENGTH = 10;
const MAX_TEMPLATE_TAG_LENGTH = exports.MAX_TEMPLATE_TAG_LENGTH = 50;
const MAX_TAGS_PER_TEMPLATE = exports.MAX_TAGS_PER_TEMPLATE = 10;
const MAX_FILENAME_LENGTH = exports.MAX_FILENAME_LENGTH = 160;
const MAX_CUSTOM_OBSERVABLE_TYPES_LABEL_LENGTH = exports.MAX_CUSTOM_OBSERVABLE_TYPES_LABEL_LENGTH = 50;

/**
 * Cases features
 */

const DEFAULT_FEATURES = exports.DEFAULT_FEATURES = Object.freeze({
  alerts: {
    sync: true,
    enabled: true,
    isExperimental: false
  },
  metrics: [],
  observables: {
    enabled: true,
    autoExtract: false
  },
  events: {
    enabled: false
  }
});

/**
 * Task manager
 */

const CASES_TELEMETRY_TASK_NAME = exports.CASES_TELEMETRY_TASK_NAME = 'cases-telemetry-task';
const ANALYTICS_BACKFILL_TASK_TYPE = exports.ANALYTICS_BACKFILL_TASK_TYPE = 'cai:cases_analytics_index_backfill';
const ANALYTICS_SCHEDULER_TASK_TYPE = exports.ANALYTICS_SCHEDULER_TASK_TYPE = 'cai:cases_analytics_index_scheduler';
const ANALYTICS_SYNCHRONIZATION_TASK_TYPE = exports.ANALYTICS_SYNCHRONIZATION_TASK_TYPE = 'cai:cases_analytics_index_synchronization';

/**
 * Telemetry
 */
const CASE_TELEMETRY_SAVED_OBJECT = exports.CASE_TELEMETRY_SAVED_OBJECT = 'cases-telemetry';
const CASE_TELEMETRY_SAVED_OBJECT_ID = exports.CASE_TELEMETRY_SAVED_OBJECT_ID = 'cases-telemetry';

/**
 * Cases UI Capabilities
 */
const CREATE_CASES_CAPABILITY = exports.CREATE_CASES_CAPABILITY = 'create_cases';
const READ_CASES_CAPABILITY = exports.READ_CASES_CAPABILITY = 'read_cases';
const UPDATE_CASES_CAPABILITY = exports.UPDATE_CASES_CAPABILITY = 'update_cases';
const DELETE_CASES_CAPABILITY = exports.DELETE_CASES_CAPABILITY = 'delete_cases';
const PUSH_CASES_CAPABILITY = exports.PUSH_CASES_CAPABILITY = 'push_cases';
const CASES_SETTINGS_CAPABILITY = exports.CASES_SETTINGS_CAPABILITY = 'cases_settings';
const CASES_CONNECTORS_CAPABILITY = exports.CASES_CONNECTORS_CAPABILITY = 'cases_connectors';
const CASES_REOPEN_CAPABILITY = exports.CASES_REOPEN_CAPABILITY = 'case_reopen';
const CREATE_COMMENT_CAPABILITY = exports.CREATE_COMMENT_CAPABILITY = 'create_comment';
const ASSIGN_CASE_CAPABILITY = exports.ASSIGN_CASE_CAPABILITY = 'cases_assign';

/**
 * Cases API Tags
 */

/**
 * This tag registered for the cases suggest user profiles API
 */
const SUGGEST_USER_PROFILES_API_TAG = exports.SUGGEST_USER_PROFILES_API_TAG = 'casesSuggestUserProfiles';

/**
 * This tag is registered for the security bulk get API
 */
const BULK_GET_USER_PROFILES_API_TAG = exports.BULK_GET_USER_PROFILES_API_TAG = 'bulkGetUserProfiles';

/**
 * This tag is registered for the connectors (configure) get API
 */
const GET_CONNECTORS_CONFIGURE_API_TAG = exports.GET_CONNECTORS_CONFIGURE_API_TAG = 'casesGetConnectorsConfigure';

/**
 * User profiles
 */

const DEFAULT_USER_SIZE = exports.DEFAULT_USER_SIZE = 10;
const MAX_ASSIGNEES_PER_CASE = exports.MAX_ASSIGNEES_PER_CASE = 10;
const NO_ASSIGNEES_FILTERING_KEYWORD = exports.NO_ASSIGNEES_FILTERING_KEYWORD = 'none';
const KIBANA_SYSTEM_USERNAME = exports.KIBANA_SYSTEM_USERNAME = 'elastic/kibana';
const MAX_OBSERVABLES_PER_CASE = exports.MAX_OBSERVABLES_PER_CASE = 50;

/**
 * Delays
 */
const SEARCH_DEBOUNCE_MS = exports.SEARCH_DEBOUNCE_MS = 500;

/**
 * Local storage keys
 */
const LOCAL_STORAGE_KEYS = exports.LOCAL_STORAGE_KEYS = {
  casesTableColumns: 'cases.list.tableColumns',
  casesTableFiltersConfig: 'cases.list.tableFiltersConfig',
  casesTableState: 'cases.list.state'
};

/**
 * Connectors
 */
let CASES_CONNECTOR_SUB_ACTION = exports.CASES_CONNECTOR_SUB_ACTION = /*#__PURE__*/function (CASES_CONNECTOR_SUB_ACTION) {
  CASES_CONNECTOR_SUB_ACTION["RUN"] = "run";
  return CASES_CONNECTOR_SUB_ACTION;
}({});
const NONE_CONNECTOR_ID = exports.NONE_CONNECTOR_ID = 'none';
const CASES_CONNECTOR_ID = exports.CASES_CONNECTOR_ID = '.cases';
const CASES_CONNECTOR_TITLE = exports.CASES_CONNECTOR_TITLE = 'Cases';
const CASES_CONNECTOR_TIME_WINDOW_REGEX = exports.CASES_CONNECTOR_TIME_WINDOW_REGEX = '^[1-9][0-9]*[d,w,h,m]$';

/**
 * This field is used for authorization of the entities within the cases plugin. Each entity within Cases will have the owner field
 * set to a string that represents the plugin that "owns" (i.e. the plugin that originally issued the POST request to
 * create the entity) the entity.
 *
 * The Authorization class constructs a string composed of the operation being performed (createCase, getComment, etc),
 * and the owner of the entity being acted upon or created. This string is then given to the Security plugin which
 * checks to see if the user making the request has that particular string stored within it's privileges. If it does,
 * then the operation succeeds, otherwise the operation fails.
 *
 * APIs that create/update an entity require that the owner field be passed in the body of the request.
 * APIs that search for entities typically require that the owner be passed as a query parameter.
 * APIs that specify an ID of an entity directly generally don't need to specify the owner field.
 *
 * For APIs that create/update an entity, the RBAC implementation checks to see if the user making the request has the
 * correct privileges for performing that action (a create/update) for the specified owner.
 * This check is done through the Security plugin's API.
 *
 * For APIs that search for entities, the RBAC implementation creates a filter for the saved objects query that limits
 * the search to only owners that the user has access to. We also check that the objects returned by the saved objects
 * API have the limited owner scope. If we find one that the user does not have permissions for, we throw a 403 error.
 * The owner field that is passed in as a query parameter can be used to further limit the results. If a user attempts
 * to pass an owner that they do not have access to, the owner is ignored.
 *
 * For APIs that retrieve/delete entities directly using their ID, the RBAC implementation requests the object first,
 * and then checks to see if the user making the request has access to that operation and owner. If the user does, the
 * operation continues, otherwise we throw a 403.
 */
const OWNER_FIELD = exports.OWNER_FIELD = 'owner';
const MAX_OBSERVABLE_TYPE_KEY_LENGTH = exports.MAX_OBSERVABLE_TYPE_KEY_LENGTH = 36;
const MAX_OBSERVABLE_TYPE_LABEL_LENGTH = exports.MAX_OBSERVABLE_TYPE_LABEL_LENGTH = 50;
const MAX_CUSTOM_OBSERVABLE_TYPES = exports.MAX_CUSTOM_OBSERVABLE_TYPES = 10;

/**
 * EBT events
 */
const CASE_PAGE_VIEW_EVENT_TYPE = exports.CASE_PAGE_VIEW_EVENT_TYPE = 'case_page_view';