"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.fullscreenClass = void 0;
exports.setFullscreen = setFullscreen;
var _kibana_services = require("../services/kibana_services");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const fullscreenClass = exports.fullscreenClass = 'canvas-isFullscreen';
function setFullscreen(fullscreen, doc = document) {
  const enabled = Boolean(fullscreen);
  const body = doc.querySelector('body');
  const bodyClassList = body.classList;
  const isFullscreen = bodyClassList.contains(fullscreenClass);
  if (enabled && !isFullscreen) {
    _kibana_services.coreServices.chrome.setIsVisible(false);
    bodyClassList.add(fullscreenClass);
  } else if (!enabled && isFullscreen) {
    bodyClassList.remove(fullscreenClass);
    _kibana_services.coreServices.chrome.setIsVisible(true);
  }
}