"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FunctionForm = void 0;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _function_form_component = require("./function_form_component");
var _function_unknown = require("./function_unknown");
var _function_form_context_pending = require("./function_form_context_pending");
var _function_form_context_error = require("./function_form_context_error");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/public/components/function_form/function_form.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// helper to check the state of the passed in expression type
function is(state, expressionType, context) {
  const matchState = !context || context.state === state;
  return expressionType && expressionType.requiresContext && matchState;
}
const FunctionForm = props => {
  const {
    expressionType,
    context
  } = props;
  if (!expressionType) {
    return /*#__PURE__*/_react.default.createElement(_function_unknown.FunctionUnknown, {
      argType: props.argType,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 32,
        columnNumber: 12
      }
    });
  }
  if (is('pending', expressionType, context)) {
    return /*#__PURE__*/_react.default.createElement(_function_form_context_pending.FunctionFormContextPending, {
      context: props.context,
      expressionType: props.expressionType,
      updateContext: props.updateContext,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 7
      }
    });
  }
  if (is('error', expressionType, context)) {
    return /*#__PURE__*/_react.default.createElement(_function_form_context_error.FunctionFormContextError, {
      context: context !== null && context !== void 0 ? context : {
        state: 'error',
        error: 'Error occured',
        value: expressionType
      },
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 47,
        columnNumber: 7
      }
    });
  }
  return /*#__PURE__*/_react.default.createElement(_function_form_component.FunctionFormComponent, (0, _extends2.default)({}, props, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 10
    }
  }));
};
exports.FunctionForm = FunctionForm;