"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ExtendedTemplate = void 0;
var _react = _interopRequireWildcard(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _eui = require("@elastic/eui");
var _saferLodashSet = require("@kbn/safer-lodash-set");
var _default_expression = require("./default_expression");
var _utils = require("./utils");
var _i18n = require("../../../../i18n");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/canvas/canvas_plugin_src/uis/arguments/partition_labels/extended_template.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const {
  PartitionLabels: strings
} = _i18n.ArgumentStrings;
const SHOW_FIELD = 'show';
const POSITION_FIELD = 'position';
const VALUES_FIELD = 'values';
const VALUES_FORMAT_FIELD = 'valuesFormat';
const PERCENT_DECIMALS_FIELD = 'percentDecimals';
const ExtendedTemplate = ({
  onValueChange,
  argValue
}) => {
  const showLabels = (0, _utils.getFieldValue)(argValue, SHOW_FIELD);
  const showValues = (0, _utils.getFieldValue)(argValue, VALUES_FIELD);
  const valueFormat = (0, _utils.getFieldValue)(argValue, VALUES_FORMAT_FIELD);
  const percentDecimals = (0, _utils.getFieldValue)(argValue, PERCENT_DECIMALS_FIELD);
  const positions = [{
    text: strings.getPositionDefaultLabel(),
    value: 'default'
  }, {
    text: strings.getPositionInsideLabel(),
    value: 'inside'
  }];
  const valuesFormats = [{
    text: strings.getValuesFormatValueLabel(),
    value: 'value'
  }, {
    text: strings.getValuesFormatPercentLabel(),
    value: 'percent'
  }];
  (0, _react.useEffect)(() => {
    if (!argValue) {
      onValueChange((0, _default_expression.defaultExpression)());
    }
  }, [argValue, onValueChange]);
  const onChangeField = (0, _react.useCallback)((field, value) => {
    const path = (0, _utils.getFieldPath)(field);
    const oldArgValue = argValue !== null && argValue !== void 0 ? argValue : (0, _default_expression.defaultExpression)();
    const newArgValue = (0, _saferLodashSet.set)(oldArgValue, path, value);
    onValueChange(newArgValue);
  }, [argValue, onValueChange]);
  const onToggleFieldChange = (0, _react.useCallback)(field => event => {
    onChangeField(field, event.target.checked);
  }, [onChangeField]);
  const onCommonFieldChange = (0, _react.useCallback)(field => event => {
    onChangeField(field, event.currentTarget.value);
  }, [onChangeField]);
  if (!showLabels) {
    return /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      color: "subdued",
      size: "xs",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 88,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement("p", {
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 89,
        columnNumber: 9
      }
    }, strings.getSwitchedOffShowLabelsLabel()));
  }
  return /*#__PURE__*/_react.default.createElement(_react.default.Fragment, null, /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getPositionLabel(),
    display: "columnCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    compressed: true,
    value: (0, _utils.getFieldValue)(argValue, POSITION_FIELD),
    options: positions,
    onChange: onCommonFieldChange(POSITION_FIELD),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 9
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiSpacer, {
    size: "s",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 104,
      columnNumber: 7
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getValuesLabel(),
    display: "columnCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSwitch, {
    compressed: true,
    checked: showValues,
    onChange: onToggleFieldChange(VALUES_FIELD),
    label: strings.getValuesToggle(),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 106,
      columnNumber: 9
    }
  })), showValues && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getValuesFormatLabel(),
    display: "columnCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 114,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiSelect, {
    compressed: true,
    value: valueFormat,
    options: valuesFormats,
    onChange: onCommonFieldChange(VALUES_FORMAT_FIELD),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 115,
      columnNumber: 11
    }
  })), showValues && valueFormat === 'percent' && /*#__PURE__*/_react.default.createElement(_eui.EuiFormRow, {
    label: strings.getPercentDecimalsLabel(),
    display: "columnCompressed",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 124,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiRange, {
    compressed: true,
    min: 0,
    max: 10,
    step: 1,
    showLabels: true,
    showInput: true,
    value: percentDecimals,
    onChange: (e, isValid) => {
      if (isValid) {
        onCommonFieldChange(PERCENT_DECIMALS_FIELD)(e);
      }
    },
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 125,
      columnNumber: 11
    }
  })));
};
exports.ExtendedTemplate = ExtendedTemplate;
ExtendedTemplate.propTypes = {
  onValueChange: _propTypes.default.func.isRequired,
  argValue: _propTypes.default.oneOfType([_propTypes.default.bool, _propTypes.default.object]).isRequired
};
ExtendedTemplate.displayName = 'PartitionLabelsExtendedArg';