"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.RequestContextFactory = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _coreSavedObjectsUtilsServer = require("@kbn/core-saved-objects-utils-server");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

class RequestContextFactory {
  constructor(options) {
    (0, _defineProperty2.default)(this, "logger", void 0);
    this.options = options;
    this.logger = options.logger;
  }
  async create(context, request) {
    const {
      options
    } = this;
    const {
      core
    } = options;
    const [coreStart, startPlugins] = await core.getStartServices();
    const coreContext = await context.core;
    const getSpaceId = () => {
      var _startPlugins$spaces, _startPlugins$spaces$;
      return ((_startPlugins$spaces = startPlugins.spaces) === null || _startPlugins$spaces === void 0 ? void 0 : (_startPlugins$spaces$ = _startPlugins$spaces.spacesService) === null || _startPlugins$spaces$ === void 0 ? void 0 : _startPlugins$spaces$.getSpaceId(request)) || _coreSavedObjectsUtilsServer.DEFAULT_NAMESPACE_STRING;
    };
    const getCurrentUser = async () => {
      var _contextUser;
      let contextUser = coreContext.security.authc.getCurrentUser();
      if (contextUser && !((_contextUser = contextUser) !== null && _contextUser !== void 0 && _contextUser.profile_uid)) {
        try {
          const users = await coreContext.elasticsearch.client.asCurrentUser.security.getUser({
            username: contextUser.username,
            with_profile_uid: true
          });
          if (users[contextUser.username].profile_uid) {
            contextUser = {
              ...contextUser,
              profile_uid: users[contextUser.username].profile_uid
            };
          }
        } catch (e) {
          this.logger.error(`Failed to get user profile_uid: ${e}`);
        }
      }
      return contextUser;
    };
    const savedObjectsClient = coreStart.savedObjects.getScopedClient(request);
    return {
      core: coreContext,
      actions: startPlugins.actions,
      logger: this.logger,
      getServerBasePath: () => core.http.basePath.serverBasePath,
      getSpaceId,
      getCurrentUser,
      checkPrivileges: () => {
        return startPlugins.security.authz.checkPrivilegesWithRequest(request);
      },
      inference: startPlugins.inference,
      savedObjectsClient
    };
  }
}
exports.RequestContextFactory = RequestContextFactory;