"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.buildRouteValidationWithZod = void 0;
var _zodHelpers = require("@kbn/zod-helpers");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const buildRouteValidationWithZod = schema => (inputValue, validationResult) => {
  const decoded = schema.safeParse(inputValue);
  if (decoded.success) {
    return validationResult.ok(decoded.data);
  } else {
    return validationResult.badRequest((0, _zodHelpers.stringifyZodError)(decoded.error));
  }
};
exports.buildRouteValidationWithZod = buildRouteValidationWithZod;