"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getInternalSavedObjectsClient = getInternalSavedObjectsClient;
exports.getInternalSavedObjectsClientForSpaceId = getInternalSavedObjectsClientForSpaceId;
var _coreHttpServerUtils = require("@kbn/core-http-server-utils");
var _server = require("@kbn/core/server");
var _common = require("@kbn/spaces-plugin/common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

async function getInternalSavedObjectsClient(coreStart) {
  return new _server.SavedObjectsClient(coreStart.savedObjects.createInternalRepository());
}
function getInternalSavedObjectsClientForSpaceId(coreStart, spaceId) {
  const request = (0, _coreHttpServerUtils.kibanaRequestFactory)({
    headers: {},
    path: '/',
    route: {
      settings: {}
    },
    url: {
      href: '',
      hash: ''
    },
    raw: {
      req: {
        url: '/'
      }
    }
  });
  if (spaceId && spaceId !== _common.DEFAULT_SPACE_ID) {
    coreStart.http.basePath.set(request, `/s/${spaceId}`);
  }

  // soClient as kibana internal users, be careful on how you use it, security is not enabled
  return coreStart.savedObjects.getScopedClient(request, {
    excludedExtensions: [_server.SECURITY_EXTENSION_ID]
  });
}