"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TransactionSummary = TransactionSummary;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireDefault(require("react"));
var _apmUiShared = require("@kbn/apm-ui-shared");
var _ = require(".");
var _error_count_summary_item_badge = require("./error_count_summary_item_badge");
var _http_info_summary_item = require("./http_info_summary_item");
var _transaction_result_summary_item = require("./transaction_result_summary_item");
var _user_agent_summary_item = require("./user_agent_summary_item");
var _cold_start_badge = require("../../app/transaction_details/waterfall_with_summary/waterfall_container/waterfall/badge/cold_start_badge");
var _build_url = require("../../../utils/build_url");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/summary/transaction_summary.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function getTransactionResultSummaryItem(transaction) {
  var _transaction$url, _transaction$transact, _transaction$transact2;
  const result = transaction.transaction.result;
  const urlFull = ((_transaction$url = transaction.url) === null || _transaction$url === void 0 ? void 0 : _transaction$url.full) || ((_transaction$transact = transaction.transaction) === null || _transaction$transact === void 0 ? void 0 : (_transaction$transact2 = _transaction$transact.page) === null || _transaction$transact2 === void 0 ? void 0 : _transaction$transact2.url);
  const url = urlFull !== null && urlFull !== void 0 ? urlFull : (0, _build_url.buildUrl)(transaction);
  if (url) {
    var _transaction$http, _transaction$http$req, _transaction$http2, _transaction$http2$re;
    const method = (_transaction$http = transaction.http) === null || _transaction$http === void 0 ? void 0 : (_transaction$http$req = _transaction$http.request) === null || _transaction$http$req === void 0 ? void 0 : _transaction$http$req.method;
    const status = (_transaction$http2 = transaction.http) === null || _transaction$http2 === void 0 ? void 0 : (_transaction$http2$re = _transaction$http2.response) === null || _transaction$http2$re === void 0 ? void 0 : _transaction$http2$re.status_code;
    return /*#__PURE__*/_react.default.createElement(_http_info_summary_item.HttpInfoSummaryItem, {
      method: method,
      status: status,
      url: url,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 35,
        columnNumber: 12
      }
    });
  }
  if (result) {
    return /*#__PURE__*/_react.default.createElement(_transaction_result_summary_item.TransactionResultSummaryItem, {
      transactionResult: result,
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 39,
        columnNumber: 12
      }
    });
  }
  return null;
}
function TransactionSummary({
  transaction,
  totalDuration,
  errorCount,
  coldStartBadge
}) {
  const items = [/*#__PURE__*/_react.default.createElement(_apmUiShared.Timestamp, {
    timestamp: transaction.timestamp.us / 1000,
    renderMode: "tooltip",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 47,
      columnNumber: 5
    }
  }), /*#__PURE__*/_react.default.createElement(_apmUiShared.Duration, {
    duration: transaction.transaction.duration.us,
    parent: {
      duration: totalDuration,
      type: 'trace'
    },
    showTooltip: true,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }), getTransactionResultSummaryItem(transaction), errorCount ? /*#__PURE__*/_react.default.createElement(_error_count_summary_item_badge.ErrorCountSummaryItemBadge, {
    count: errorCount,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 18
    }
  }) : null, transaction.user_agent ? /*#__PURE__*/_react.default.createElement(_user_agent_summary_item.UserAgentSummaryItem, (0, _extends2.default)({}, transaction.user_agent, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 58,
      columnNumber: 30
    }
  })) : null, coldStartBadge ? /*#__PURE__*/_react.default.createElement(_cold_start_badge.ColdStartBadge, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 22
    }
  }) : null];
  return /*#__PURE__*/_react.default.createElement(_.Summary, {
    items: items,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 62,
      columnNumber: 10
    }
  });
}