"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TotalDocCountLabel = TotalDocCountLabel;
var _react = require("@emotion/react");
var _eui = require("@elastic/eui");
var _react2 = _interopRequireDefault(require("react"));
var _i18n = require("@kbn/i18n");
var _common = require("@kbn/observability-plugin/common");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/observability/plugins/apm/public/components/shared/charts/duration_distribution_chart/total_doc_count_label.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function TotalDocCountLabel({
  eventType,
  totalDocCount
}) {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  if (!totalDocCount) {
    return null;
  }
  return /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    size: "s",
    css: (0, _react.css)`
        border-left: ${euiTheme.border.thin};
        padding-left: ${euiTheme.size.s};
      `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 27,
      columnNumber: 5
    }
  }, eventType === _common.ProcessorEvent.transaction ? _i18n.i18n.translate('xpack.apm.durationDistributionChart.totalTransactionsCount', {
    defaultMessage: '{totalDocCount} total {totalDocCount, plural, one {transaction} other {transactions}}',
    values: {
      totalDocCount
    }
  }) : _i18n.i18n.translate('xpack.apm.durationDistributionChart.totalSpansCount', {
    defaultMessage: '{totalDocCount} total {totalDocCount, plural, one {span} other {spans}}',
    values: {
      totalDocCount
    }
  }));
}