"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Centerer = Centerer;
var _react = require("react");
var _cytoscape = require("../cytoscape");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

// Component to center map on load
function Centerer() {
  const cy = (0, _react.useContext)(_cytoscape.CytoscapeContext);
  (0, _react.useEffect)(() => {
    if (cy) {
      cy.one('layoutstop', event => {
        event.cy.animate({
          duration: 50,
          center: {
            eles: ''
          },
          fit: {
            eles: '',
            padding: 50
          }
        });
      });
    }
  }, [cy]);
  return null;
}