"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ruleType = exports.mockedRuleTypeSavedObject = exports.mockedRule = exports.mockedRawRuleSO = exports.mockTaskInstance = exports.mockRunNowResponse = exports.mockDate = exports.mockAAD = exports.generateRunnerResult = exports.generateRuleUpdateParams = exports.generateEnqueueFunctionInput = exports.generateAlertOpts = exports.generateAlertInstance = exports.generateActionOpts = exports.RULE_TYPE_ID = exports.RULE_NAME = exports.RULE_ID = exports.RULE_ACTIONS = exports.MOCK_DURATION = exports.GENERIC_ERROR_MESSAGE = exports.DATE_9999 = exports.DATE_1970_5_MIN = exports.DATE_1970 = exports.DATE_1969 = void 0;
var _server = require("@kbn/task-manager-plugin/server");
var _coreSavedObjectsServer = require("@kbn/core-saved-objects-server");
var _common = require("../../common");
var _monitoring = require("../lib/monitoring");
var _plugin = require("../plugin");
var _saved_objects = require("../saved_objects");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const RULE_NAME = exports.RULE_NAME = 'rule-name';
const RULE_ID = exports.RULE_ID = '1';
const RULE_TYPE_ID = exports.RULE_TYPE_ID = 'test';
const DATE_1969 = exports.DATE_1969 = '1969-12-31T00:00:00.000Z';
const DATE_1970 = exports.DATE_1970 = '1970-01-01T00:00:00.000Z';
const DATE_1970_5_MIN = exports.DATE_1970_5_MIN = '1969-12-31T23:55:00.000Z';
const DATE_9999 = exports.DATE_9999 = '9999-12-31T12:34:56.789Z';
const MOCK_DURATION = exports.MOCK_DURATION = '86400000000000';
const RULE_ACTIONS = exports.RULE_ACTIONS = [{
  actionTypeId: 'action',
  group: 'default',
  id: '1',
  params: {
    foo: true
  },
  uuid: '111-111'
}, {
  actionTypeId: 'action',
  group: 'recovered',
  id: '2',
  params: {
    isResolved: true
  },
  uuid: '222-222'
}];
const defaultHistory = [{
  success: true,
  timestamp: 0
}];
const generateRuleUpdateParams = ({
  error = null,
  warning = null,
  status = 'ok',
  outcome = 'succeeded',
  nextRun = '1970-01-01T00:00:10.000Z',
  successRatio = 1,
  history = defaultHistory,
  alertsCount
}) => [{
  id: `alert:1`,
  index: _coreSavedObjectsServer.ALERTING_CASES_SAVED_OBJECT_INDEX,
  doc: {
    alert: {
      monitoring: {
        run: {
          calculated_metrics: {
            success_ratio: successRatio
          },
          history,
          last_run: {
            timestamp: '1970-01-01T00:00:00.000Z',
            metrics: {
              duration: 0,
              gap_duration_s: null,
              // TODO: uncomment after intermidiate release
              // gap_range: null,
              total_alerts_created: null,
              total_alerts_detected: null,
              total_indexing_duration_ms: null,
              total_search_duration_ms: null
            }
          }
        }
      },
      executionStatus: {
        error,
        lastDuration: 0,
        lastExecutionDate: '1970-01-01T00:00:00.000Z',
        status,
        warning
      },
      lastRun: {
        outcome,
        outcomeOrder: _common.RuleLastRunOutcomeOrderMap[outcome],
        outcomeMsg: (error === null || error === void 0 ? void 0 : error.message) && [error === null || error === void 0 ? void 0 : error.message] || (warning === null || warning === void 0 ? void 0 : warning.message) && [warning === null || warning === void 0 ? void 0 : warning.message] || null,
        warning: (error === null || error === void 0 ? void 0 : error.reason) || (warning === null || warning === void 0 ? void 0 : warning.reason) || null,
        alertsCount: {
          active: 0,
          ignored: 0,
          new: 0,
          recovered: 0,
          ...(alertsCount || {})
        }
      },
      nextRun,
      running: false
    }
  }
}, {
  ignore: [404]
}];
exports.generateRuleUpdateParams = generateRuleUpdateParams;
const GENERIC_ERROR_MESSAGE = exports.GENERIC_ERROR_MESSAGE = 'GENERIC ERROR MESSAGE';
const ruleType = exports.ruleType = {
  id: RULE_TYPE_ID,
  name: 'My test rule',
  actionGroups: [{
    id: 'default',
    name: 'Default'
  }, _common.RecoveredActionGroup],
  defaultActionGroupId: 'default',
  minimumLicenseRequired: 'basic',
  isExportable: true,
  recoveryActionGroup: _common.RecoveredActionGroup,
  executor: jest.fn(),
  category: 'test',
  producer: 'alerts',
  solution: 'stack',
  cancelAlertsOnRuleTimeout: true,
  ruleTaskTimeout: '5m',
  autoRecoverAlerts: true,
  validate: {
    params: {
      validate: params => params
    }
  },
  alerts: {
    context: 'test',
    mappings: {
      fieldMap: {
        field: {
          type: 'keyword',
          required: false
        }
      }
    }
  },
  validLegacyConsumers: []
};
const mockRunNowResponse = exports.mockRunNowResponse = {
  id: 1
};
const mockDate = exports.mockDate = new Date('2019-02-12T21:01:22.479Z');
const mockedRuleTypeSavedObject = exports.mockedRuleTypeSavedObject = {
  id: '1',
  consumer: 'bar',
  createdAt: mockDate,
  updatedAt: mockDate,
  throttle: null,
  muteAll: false,
  notifyWhen: 'onActiveAlert',
  enabled: true,
  alertTypeId: ruleType.id,
  apiKey: '',
  apiKeyOwner: 'elastic',
  schedule: {
    interval: '10s'
  },
  name: RULE_NAME,
  tags: ['rule-', '-tags'],
  createdBy: 'rule-creator',
  updatedBy: 'rule-updater',
  mutedInstanceIds: [],
  params: {
    bar: true
  },
  actions: [{
    group: 'default',
    id: '1',
    actionTypeId: 'action',
    params: {
      foo: true
    },
    uuid: '111-111'
  }, {
    group: _common.RecoveredActionGroup.id,
    id: '2',
    actionTypeId: 'action',
    params: {
      isResolved: true
    },
    uuid: '222-222'
  }],
  executionStatus: {
    status: 'unknown',
    lastExecutionDate: new Date('2020-08-20T19:23:38Z')
  },
  monitoring: (0, _monitoring.getDefaultMonitoring)('2020-08-20T19:23:38Z'),
  revision: 0,
  scheduledTaskId: '1'
};
const mockedRawRuleSO = exports.mockedRawRuleSO = {
  id: '1',
  type: _saved_objects.RULE_SAVED_OBJECT_TYPE,
  references: [],
  attributes: {
    legacyId: '1',
    consumer: 'bar',
    createdAt: mockDate.toString(),
    updatedAt: mockDate.toString(),
    throttle: null,
    muteAll: false,
    notifyWhen: 'onActiveAlert',
    enabled: true,
    alertTypeId: ruleType.id,
    apiKey: 'MTIzOmFiYw==',
    apiKeyOwner: 'elastic',
    schedule: {
      interval: '10s'
    },
    name: RULE_NAME,
    tags: ['rule-', '-tags'],
    createdBy: 'rule-creator',
    updatedBy: 'rule-updater',
    mutedInstanceIds: [],
    params: {
      bar: true
    },
    actions: [{
      group: 'default',
      actionTypeId: 'action',
      params: {
        foo: true
      },
      uuid: '111-111',
      actionRef: '1'
    }, {
      group: _common.RecoveredActionGroup.id,
      actionTypeId: 'action',
      params: {
        isResolved: true
      },
      uuid: '222-222',
      actionRef: '2'
    }],
    executionStatus: {
      status: 'unknown',
      lastExecutionDate: new Date('2020-08-20T19:23:38Z').toString(),
      error: null,
      warning: null
    },
    monitoring: (0, _monitoring.getDefaultMonitoring)('2020-08-20T19:23:38Z'),
    revision: 0,
    scheduledTaskId: '1'
  }
};
const mockedRule = exports.mockedRule = {
  id: mockedRawRuleSO.id,
  ...mockedRawRuleSO.attributes,
  nextRun: undefined,
  createdAt: new Date(mockedRawRuleSO.attributes.createdAt),
  updatedAt: new Date(mockedRawRuleSO.attributes.updatedAt),
  executionStatus: {
    ...mockedRawRuleSO.attributes.executionStatus,
    lastExecutionDate: new Date(mockedRawRuleSO.attributes.executionStatus.lastExecutionDate),
    error: undefined,
    warning: undefined
  },
  actions: mockedRawRuleSO.attributes.actions.map(action => {
    return {
      ...action,
      id: action.uuid
    };
  }),
  isSnoozedUntil: undefined,
  artifacts: {
    dashboards: [{
      id: 'dashboard-1'
    }],
    investigation_guide: {
      blob: '## Summary'
    }
  }
};
const mockTaskInstance = () => ({
  id: '1',
  attempts: 0,
  status: _server.TaskStatus.Running,
  version: '123',
  runAt: new Date(),
  schedule: {
    interval: '10s'
  },
  scheduledAt: new Date(),
  startedAt: new Date(),
  retryAt: new Date(Date.now() + 5 * 60 * 1000),
  state: {},
  taskType: 'alerting:test',
  params: {
    alertId: RULE_ID,
    spaceId: 'default',
    consumer: 'bar'
  },
  ownerId: null
});
exports.mockTaskInstance = mockTaskInstance;
const generateAlertOpts = ({
  action,
  group,
  state,
  id,
  maintenanceWindowIds
} = {}) => {
  var _id;
  id = (_id = id) !== null && _id !== void 0 ? _id : '1';
  let message = '';
  switch (action) {
    case _plugin.EVENT_LOG_ACTIONS.newInstance:
      message = `test:1: 'rule-name' created new alert: '${id}'`;
      break;
    case _plugin.EVENT_LOG_ACTIONS.activeInstance:
      message = `test:1: 'rule-name' active alert: '${id}' in actionGroup: 'default'`;
      break;
    case _plugin.EVENT_LOG_ACTIONS.recoveredInstance:
      message = `test:1: 'rule-name' alert '${id}' has recovered`;
      break;
  }
  return {
    action,
    id,
    uuid: expect.any(String),
    message,
    state,
    ...(group ? {
      group
    } : {}),
    flapping: false,
    ...(maintenanceWindowIds ? {
      maintenanceWindowIds
    } : {})
  };
};
exports.generateAlertOpts = generateAlertOpts;
const generateActionOpts = ({
  id,
  alertGroup,
  alertId,
  uuid
} = {}) => ({
  id: id !== null && id !== void 0 ? id : '1',
  typeId: 'action',
  uuid: uuid !== null && uuid !== void 0 ? uuid : '111-111',
  alertId: alertId !== null && alertId !== void 0 ? alertId : '1',
  alertGroup: alertGroup !== null && alertGroup !== void 0 ? alertGroup : 'default'
});
exports.generateActionOpts = generateActionOpts;
const generateRunnerResult = ({
  successRatio = 1,
  history = Array(false),
  state = false,
  interval = '10s',
  alertInstances = {},
  alertRecoveredInstances = {},
  summaryActions = {},
  taskRunError
} = {}) => {
  return {
    schedule: {
      interval
    },
    state: {
      ...(state && {
        alertInstances
      }),
      ...(state && {
        alertRecoveredInstances
      }),
      ...(state && {
        alertTypeState: {}
      }),
      ...(state && {
        previousStartedAt: new Date('1970-01-01T00:00:00.000Z').toISOString()
      }),
      ...(state && {
        summaryActions
      })
    },
    taskRunError
  };
};
exports.generateRunnerResult = generateRunnerResult;
const generateEnqueueFunctionInput = ({
  id = '1',
  uuid = '111-111',
  isBulk = false,
  isResolved,
  foo,
  consumer,
  actionTypeId,
  priority,
  apiKeyId
}) => {
  const input = {
    actionTypeId: actionTypeId || 'action',
    apiKey: 'MTIzOmFiYw==',
    executionId: '5f6aa57d-3e22-484e-bae8-cbed868f4d28',
    id,
    uuid,
    params: {
      ...(isResolved !== undefined ? {
        isResolved
      } : {}),
      ...(foo !== undefined ? {
        foo
      } : {})
    },
    consumer: consumer !== null && consumer !== void 0 ? consumer : 'bar',
    relatedSavedObjects: [{
      id: '1',
      namespace: undefined,
      type: _saved_objects.RULE_SAVED_OBJECT_TYPE,
      typeId: RULE_TYPE_ID
    }],
    source: {
      source: {
        id: '1',
        type: _saved_objects.RULE_SAVED_OBJECT_TYPE
      },
      type: 'SAVED_OBJECT'
    },
    spaceId: 'default',
    ...(priority && {
      priority
    }),
    ...(apiKeyId && {
      apiKeyId
    })
  };
  return isBulk ? [input] : input;
};
exports.generateEnqueueFunctionInput = generateEnqueueFunctionInput;
const generateAlertInstance = ({
  id,
  duration,
  start,
  flappingHistory,
  actions,
  maintenanceWindowIds
} = {
  id: 1,
  flappingHistory: [false]
}) => ({
  [String(id)]: {
    meta: {
      uuid: expect.any(String),
      lastScheduledActions: {
        date: new Date(DATE_1970).toISOString(),
        group: 'default',
        ...(actions && {
          actions
        })
      },
      flappingHistory,
      flapping: false,
      maintenanceWindowIds: maintenanceWindowIds || [],
      pendingRecoveredCount: 0,
      activeCount: 1
    },
    state: {
      bar: false,
      duration,
      start
    }
  }
});
exports.generateAlertInstance = generateAlertInstance;
const mockAAD = exports.mockAAD = {
  '@timestamp': '2022-12-07T15:38:43.472Z',
  event: {
    kind: 'signal',
    action: 'active'
  },
  kibana: {
    version: '8.7.0',
    space_ids: ['default'],
    alert: {
      instance: {
        id: '*'
      },
      uuid: '2d3e8fe5-3e8b-4361-916e-9eaab0bf2084',
      status: 'active',
      workflow_status: 'open',
      reason: 'system.cpu is 90% in the last 1 min for all hosts. Alert when > 50%.',
      time_range: {
        gte: '2022-01-01T12:00:00.000Z'
      },
      start: '2022-12-07T15:23:13.488Z',
      duration: {
        us: 100000
      },
      flapping: false,
      rule: {
        category: 'Metric threshold',
        consumer: 'alerts',
        execution: {
          uuid: 'c35db7cc-5bf7-46ea-b43f-b251613a5b72'
        },
        name: 'test-rule',
        producer: 'infrastructure',
        revision: 0,
        rule_type_id: 'metrics.alert.threshold',
        uuid: '0de91960-7643-11ed-b719-bb9db8582cb6',
        tags: []
      }
    }
  }
};