"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateMetaAttributes = updateMetaAttributes;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function updateMetaAttributes(context, alertAttributes) {
  if (Object.hasOwn(alertAttributes, 'apiKey') || Object.hasOwn(alertAttributes, 'apiKeyOwner')) {
    var _alertAttributes$meta;
    return {
      ...alertAttributes,
      meta: {
        ...((_alertAttributes$meta = alertAttributes.meta) !== null && _alertAttributes$meta !== void 0 ? _alertAttributes$meta : {}),
        versionApiKeyLastmodified: context.kibanaVersion
      }
    };
  }
  return alertAttributes;
}