"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformFromLegacyActions = void 0;
var _uuid = require("uuid");
var _fp = require("lodash/fp");
var _transform_to_notify_when = require("./transform_to_notify_when");
var _transform_to_alert_throttle = require("./transform_to_alert_throttle");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * @deprecated Once we are confident all rules relying on side-car actions SO's have been migrated to SO references we should remove this function
 * transforms siem legacy actions {@link LegacyIRuleActionsAttributes} objects into {@link RawRuleAction}
 * @param legacyActionsAttr
 * @param references
 * @returns array of RawRuleAction
 */
const transformFromLegacyActions = (legacyActionsAttr, references) => {
  const actionReference = references.reduce((acc, reference) => {
    acc[reference.name] = reference;
    return acc;
  }, {});
  if ((0, _fp.isEmpty)(actionReference)) {
    throw new Error(`Connector reference id not found.`);
  }
  return legacyActionsAttr.actions.reduce((acc, action) => {
    var _transformToNotifyWhe;
    const {
      actionRef,
      action_type_id: actionTypeId,
      group,
      params
    } = action;
    if (!actionReference[actionRef]) {
      return acc;
    }
    return [...acc, {
      group,
      params,
      uuid: (0, _uuid.v4)(),
      actionRef,
      actionTypeId,
      frequency: {
        summary: true,
        notifyWhen: (_transformToNotifyWhe = (0, _transform_to_notify_when.transformToNotifyWhen)(legacyActionsAttr.ruleThrottle)) !== null && _transformToNotifyWhe !== void 0 ? _transformToNotifyWhe : 'onActiveAlert',
        throttle: (0, _transform_to_alert_throttle.transformToAlertThrottle)(legacyActionsAttr.ruleThrottle)
      }
    }];
  }, []);
};
exports.transformFromLegacyActions = transformFromLegacyActions;