"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.bulkDeleteRulesRoute = void 0;
var _lib = require("../../../lib");
var _lib2 = require("../../../../lib");
var _types = require("../../../../types");
var _bulk_delete = require("../../../../../common/routes/rule/apis/bulk_delete");
var _transforms = require("../../transforms");
var _constants = require("../../../constants");
var _validate_internal_rule_types_by_query = require("../../../lib/validate_internal_rule_types_by_query");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const bulkDeleteRulesRoute = ({
  router,
  licenseState
}) => {
  router.patch({
    path: `${_types.INTERNAL_BASE_ALERTING_API_PATH}/rules/_bulk_delete`,
    security: _constants.DEFAULT_ALERTING_ROUTE_SECURITY,
    options: {
      access: 'internal'
    },
    validate: {
      body: _bulk_delete.bulkDeleteRulesRequestBodySchemaV1
    }
  }, (0, _lib.handleDisabledApiKeysError)(router.handleLegacyErrors((0, _lib.verifyAccessAndContext)(licenseState, async (context, req, res) => {
    const alertingContext = await context.alerting;
    const rulesClient = await alertingContext.getRulesClient();
    const ruleTypes = alertingContext.listTypes();
    const body = req.body;
    const {
      filter,
      ids
    } = body;
    try {
      await (0, _validate_internal_rule_types_by_query.validateInternalRuleTypesBulkOperation)({
        ids,
        ruleTypes,
        rulesClient,
        operationText: 'delete'
      });
      const bulkDeleteResult = await rulesClient.bulkDeleteRules({
        filter,
        ids
      });
      const resultBody = {
        body: {
          ...bulkDeleteResult,
          rules: bulkDeleteResult.rules.map(rule => {
            // TODO (http-versioning): Remove this cast, this enables us to move forward
            // without fixing all of other solution types
            return (0, _transforms.transformRuleToRuleResponseV1)(rule);
          })
        }
      };
      return res.ok(resultBody);
    } catch (e) {
      if (e instanceof _lib2.RuleTypeDisabledError) {
        return e.sendResponse(res);
      }
      throw e;
    }
  }))));
};
exports.bulkDeleteRulesRoute = bulkDeleteRulesRoute;