"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.transformToGap = void 0;
var _gap = require("../gap");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const validateInterval = interval => {
  if (!(interval !== null && interval !== void 0 && interval.gte) || !(interval !== null && interval !== void 0 && interval.lte)) return null;
  return {
    lte: interval.lte,
    gte: interval.gte
  };
};
const validateIntervals = intervals => {
  var _ref, _intervals$map;
  return (_ref = intervals === null || intervals === void 0 ? void 0 : (_intervals$map = intervals.map(validateInterval)) === null || _intervals$map === void 0 ? void 0 : _intervals$map.filter(interval => interval !== null)) !== null && _ref !== void 0 ? _ref : [];
};

/**
 * Transforms event log results into Gap objects
 * Filters out invalid gaps/gaps intervals
 */
const transformToGap = events => {
  var _events$data;
  return events === null || events === void 0 ? void 0 : (_events$data = events.data) === null || _events$data === void 0 ? void 0 : _events$data.map(doc => {
    var _doc$kibana, _doc$kibana$alert, _doc$kibana$alert$rul, _doc$rule;
    const gap = doc === null || doc === void 0 ? void 0 : (_doc$kibana = doc.kibana) === null || _doc$kibana === void 0 ? void 0 : (_doc$kibana$alert = _doc$kibana.alert) === null || _doc$kibana$alert === void 0 ? void 0 : (_doc$kibana$alert$rul = _doc$kibana$alert.rule) === null || _doc$kibana$alert$rul === void 0 ? void 0 : _doc$kibana$alert$rul.gap;
    // Filter out deleted gaps in the event that we request them by id.
    // Due to a race condition when we update gaps, we could end up requesting a deleted gap by id
    // Deleted gaps should not be used by Kibana at all because it means that the rule they are associated with has been deleted
    if (!gap || gap.deleted) return null;
    const ruleId = (_doc$rule = doc.rule) === null || _doc$rule === void 0 ? void 0 : _doc$rule.id;
    if (!ruleId) {
      return null;
    }
    const range = validateInterval(gap.range);
    if (!range || !doc['@timestamp']) return null;
    const filledIntervals = validateIntervals(gap === null || gap === void 0 ? void 0 : gap.filled_intervals);
    const inProgressIntervals = validateIntervals(gap === null || gap === void 0 ? void 0 : gap.in_progress_intervals);
    return new _gap.Gap({
      ruleId,
      timestamp: doc['@timestamp'],
      range,
      filledIntervals,
      inProgressIntervals,
      internalFields: {
        _id: doc._id,
        _index: doc._index,
        _seq_no: doc._seq_no,
        _primary_term: doc._primary_term
      }
    });
  }).filter(gap => gap !== null);
};
exports.transformToGap = transformToGap;