"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.injectFrom = injectFrom;
const reflect_metadata_utils_1 = require("@inversifyjs/reflect-metadata-utils");
const classMetadataReflectKey_1 = require("../../reflectMetadata/data/classMetadataReflectKey");
const getClassMetadata_1 = require("../calculations/getClassMetadata");
const getDefaultClassMetadata_1 = require("../calculations/getDefaultClassMetadata");
const getExtendedConstructorArguments_1 = require("../calculations/getExtendedConstructorArguments");
const getExtendedProperties_1 = require("../calculations/getExtendedProperties");
function injectFrom(options) {
    // eslint-disable-next-line @typescript-eslint/no-unsafe-function-type
    const decorator = (target) => {
        const baseTypeClassMetadata = (0, getClassMetadata_1.getClassMetadata)(options.type);
        (0, reflect_metadata_utils_1.updateOwnReflectMetadata)(target, classMetadataReflectKey_1.classMetadataReflectKey, getDefaultClassMetadata_1.getDefaultClassMetadata, composeUpdateReflectMetadataCallback(options, baseTypeClassMetadata));
    };
    return decorator;
}
function composeUpdateReflectMetadataCallback(options, baseTypeClassMetadata) {
    const callback = (typeMetadata) => ({
        constructorArguments: (0, getExtendedConstructorArguments_1.getExtendedConstructorArguments)(options, baseTypeClassMetadata, typeMetadata),
        lifecycle: typeMetadata.lifecycle,
        properties: (0, getExtendedProperties_1.getExtendedProperties)(options, baseTypeClassMetadata, typeMetadata),
        scope: typeMetadata.scope,
    });
    return callback;
}
//# sourceMappingURL=injectFrom.js.map