"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.euiFormVariables = exports.euiFormPlaceholderStyles = exports.euiFormMaxWidth = exports.euiFormCustomControlVariables = exports.euiFormCustomControlStyles = exports.euiFormControlText = exports.euiFormControlStyles = exports.euiFormControlShowBackgroundLine = exports.euiFormControlReadOnlyStyles = exports.euiFormControlInvalidStyles = exports.euiFormControlHoverStyles = exports.euiFormControlHighlightBorderStyles = exports.euiFormControlFocusStyles = exports.euiFormControlDisabledStyles = exports.euiFormControlDefaultShadow = exports.euiFormControlAutoFillStyles = exports.disableFormControlHoverStyles = void 0;
var _services = require("../../services");
var _global_styling = require("../../global_styling");
var _high_contrast = require("../../global_styling/functions/high_contrast");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
// There are multiple components that only need the form max-width size &
// don't need the extra overhead/color computing expense of every form var.
// For microperf, we're making this its own util
var euiFormMaxWidth = exports.euiFormMaxWidth = function euiFormMaxWidth(_ref) {
  var euiTheme = _ref.euiTheme;
  return euiTheme.components.forms.maxWidth;
};
var euiFormPlaceholderStyles = exports.euiFormPlaceholderStyles = function euiFormPlaceholderStyles(euiThemeContext, color) {
  var form = euiFormVariables(euiThemeContext);
  var _color = color !== null && color !== void 0 ? color : form.textColorDisabled;
  return "\n    color: ".concat(_color, ";\n    opacity: 1;\n  ");
};
var euiFormVariables = exports.euiFormVariables = function euiFormVariables(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  var isRefreshVariant = (0, _services.isEuiThemeRefreshVariant)(euiThemeContext, 'formVariant');
  var backgroundColor = highContrastMode ? euiTheme.colors.emptyShade : euiTheme.components.forms.background;
  var controlHeight = euiTheme.size.xxl;
  var controlCompressedHeight = euiTheme.size.xl;
  var sizes = {
    maxWidth: euiFormMaxWidth(euiThemeContext),
    controlHeight: controlHeight,
    controlCompressedHeight: controlCompressedHeight,
    controlPadding: euiTheme.size.m,
    controlCompressedPadding: euiTheme.size.s,
    controlBorderRadius: isRefreshVariant ? euiTheme.border.radius.small : euiTheme.border.radius.medium,
    controlCompressedBorderRadius: euiTheme.border.radius.small,
    iconAffordance: (0, _global_styling.mathWithUnits)(euiTheme.size.base, function (x) {
      return x * 1.5;
    }),
    iconCompressedAffordance: (0, _global_styling.mathWithUnits)(isRefreshVariant ? euiTheme.size.base : euiTheme.size.m, function (x) {
      return x * 1.5;
    }),
    stateUnderlineHeight: highContrastMode ? (0, _global_styling.mathWithUnits)(euiTheme.border.width.thick, function (x) {
      return x * 2;
    }) : euiTheme.border.width.thick
  };
  var colors = {
    textColor: euiTheme.colors.textParagraph,
    textColorDisabled: euiTheme.components.forms.colorDisabled,
    backgroundColor: backgroundColor,
    backgroundDisabledColor: euiTheme.components.forms.backgroundDisabled,
    backgroundReadOnlyColor: euiTheme.components.forms.backgroundReadOnly,
    borderColor: highContrastMode ? euiTheme.border.color : euiTheme.components.forms.border,
    borderHovered: euiTheme.components.forms.borderHovered,
    borderFocused: euiTheme.components.forms.borderFocused,
    borderInvalid: euiTheme.components.forms.borderInvalid,
    borderInvalidHovered: euiTheme.components.forms.borderInvalidHovered,
    controlDisabledColor: euiTheme.components.forms.controlBackgroundDisabled,
    controlBoxShadow: '0 0 transparent',
    controlPlaceholderText: isRefreshVariant ? highContrastMode ? (0, _services.makeHighContrastColor)(euiTheme.components.forms.colorDisabled)(backgroundColor) : euiTheme.components.forms.colorDisabled : (0, _services.makeHighContrastColor)(euiTheme.colors.textSubdued)(backgroundColor),
    appendPrependBackground: euiTheme.components.forms.prependBackground
  };
  var controlLayout = {
    controlLayoutGroupInputHeight: (0, _global_styling.mathWithUnits)(controlHeight, function (x) {
      return x - 2;
    }),
    controlLayoutGroupInputCompressedHeight: (0, _global_styling.mathWithUnits)(controlCompressedHeight, function (x) {
      return x - 2;
    }),
    controlLayoutGroupInputCompressedBorderRadius: euiTheme.border.radius.small
  };
  var iconSizes = {
    controlIconSize: {
      s: euiTheme.size.m,
      m: euiTheme.size.base,
      l: euiTheme.size.l,
      xl: euiTheme.size.xl,
      xxl: euiTheme.size.xxl
    }
  };
  return _objectSpread(_objectSpread(_objectSpread(_objectSpread(_objectSpread({}, sizes), colors), iconSizes), controlLayout), {}, {
    animationTiming: "".concat(euiTheme.animation.fast, " ease-in")
  });
};
var formControlLayoutWrapperSelector = '.euiFormControlLayout__childrenWrapper';
var euiFormControlStyles = exports.euiFormControlStyles = function euiFormControlStyles(euiThemeContext) {
  var isRefreshVariant = (0, _services.isEuiThemeRefreshVariant)(euiThemeContext, 'formVariant');
  var form = euiFormVariables(euiThemeContext);
  return {
    shared: "\n      ".concat(euiFormControlText(euiThemeContext), "\n      ").concat(euiFormControlDefaultShadow(euiThemeContext), "\n    "),
    // Sizes
    uncompressed: "\n      ".concat((0, _global_styling.logicalCSS)('height', form.controlHeight), "\n      ").concat((0, _global_styling.logicalCSS)('padding-vertical', form.controlPadding), "\n      ").concat((0, _global_styling.logicalCSS)('padding-left', "calc(".concat(form.controlPadding, " + (").concat(form.iconAffordance, " * var(--euiFormControlLeftIconsCount, 0)))")), "\n      ").concat((0, _global_styling.logicalCSS)('padding-right', "calc(".concat(form.controlPadding, " + (").concat(form.iconAffordance, " * var(--euiFormControlRightIconsCount, 0)))")), "\n      border-radius: ").concat(form.controlBorderRadius, ";\n    "),
    compressed: "\n      ".concat((0, _global_styling.logicalCSS)('height', form.controlCompressedHeight), "\n      ").concat((0, _global_styling.logicalCSS)('padding-vertical', form.controlCompressedPadding), "\n      ").concat((0, _global_styling.logicalCSS)('padding-left', "calc(".concat(form.controlCompressedPadding, " + (").concat(form.iconCompressedAffordance, " * var(--euiFormControlLeftIconsCount, 0)))")), "\n      ").concat((0, _global_styling.logicalCSS)('padding-right', "calc(".concat(form.controlCompressedPadding, " + (").concat(form.iconCompressedAffordance, " * var(--euiFormControlRightIconsCount, 0)))")), "\n      border-radius: ").concat(form.controlCompressedBorderRadius, ";\n    "),
    // In group
    inGroup: "\n      ".concat((0, _global_styling.logicalCSS)('height', '100%'), "\n      ").concat((0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
      none: 'box-shadow: none;',
      preferred: 'border: none;'
    }), "\n      border-radius: ").concat(isRefreshVariant ? 'inherit' : '0', ";\n    "),
    // Widths
    formWidth: "\n      ".concat((0, _global_styling.logicalCSS)('max-width', form.maxWidth), "\n      ").concat((0, _global_styling.logicalCSS)('width', '100%'), "\n    "),
    fullWidth: "\n      ".concat((0, _global_styling.logicalCSS)('max-width', '100%'), "\n      ").concat((0, _global_styling.logicalCSS)('width', '100%'), "\n    "),
    // States
    invalid: euiFormControlInvalidStyles(euiThemeContext),
    focus: euiFormControlFocusStyles(euiThemeContext),
    disabled: euiFormControlDisabledStyles(euiThemeContext),
    readOnly: euiFormControlReadOnlyStyles(euiThemeContext),
    autoFill: euiFormControlAutoFillStyles(euiThemeContext)
  };
};
var euiFormControlText = exports.euiFormControlText = function euiFormControlText(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var _euiFontSize = (0, _global_styling.euiFontSize)(euiThemeContext, 's'),
    fontSize = _euiFontSize.fontSize;
  var form = euiFormVariables(euiThemeContext);
  return "\n    font-family: ".concat(euiTheme.font.family, ";\n    font-size: ").concat(fontSize, ";\n    color: ").concat(form.textColor, ";\n\n    ").concat(euiPlaceholderPerBrowser(euiFormPlaceholderStyles(euiThemeContext, form.controlPlaceholderText)), "\n  ");
};
var euiFormControlDefaultShadow = exports.euiFormControlDefaultShadow = function euiFormControlDefaultShadow(euiThemeContext) {
  var _ref2 = arguments.length > 1 && arguments[1] !== undefined ? arguments[1] : {},
    _ref2$withBorder = _ref2.withBorder,
    withBorder = _ref2$withBorder === void 0 ? true : _ref2$withBorder,
    _ref2$withBackground = _ref2.withBackground,
    withBackground = _ref2$withBackground === void 0 ? true : _ref2$withBackground,
    _ref2$withBackgroundC = _ref2.withBackgroundColor,
    withBackgroundColor = _ref2$withBackgroundC === void 0 ? withBackground : _ref2$withBackgroundC,
    _ref2$withBackgroundA = _ref2.withBackgroundAnimation,
    withBackgroundAnimation = _ref2$withBackgroundA === void 0 ? withBackground : _ref2$withBackgroundA;
  var euiTheme = euiThemeContext.euiTheme;
  var isRefreshVariant = (0, _services.isEuiThemeRefreshVariant)(euiThemeContext, 'formVariant');
  var form = euiFormVariables(euiThemeContext);
  var border = (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
    // We use inset box-shadow instead of border to skip extra height calculations
    none: isRefreshVariant ? "\n      --euiFormControlStateColor: ".concat(form.borderColor, ";\n      border: none;\n      box-shadow: inset 0 0 0 ").concat(euiTheme.border.width.thin, " var(--euiFormControlStateColor);\n\n      ").concat(euiFormControlHoverStyles(euiThemeContext), "\n    ") : "\n      border: none;\n      box-shadow: inset 0 0 0 ".concat(euiTheme.border.width.thin, " ").concat(form.borderColor, ";\n    "),
    // In high contrast mode, this doesn't matter - we need to prioritize visibility
    preferred: "\n      border: ".concat(euiTheme.border.width.thin, " solid ").concat(euiTheme.border.color, ";\n\n      ").concat(euiFormControlHoverStyles(euiThemeContext), "\n    ")
  });
  var backgroundColor = "\n    background-color: ".concat(form.backgroundColor, ";\n  ").trim();
  var backgroundGradient = (0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
    none: !isRefreshVariant ? "\n      background-repeat: no-repeat;\n      background-size: 0% 100%;\n      background-image: linear-gradient(to top,\n        var(--euiFormControlStateColor),\n        var(--euiFormControlStateColor) ".concat(isRefreshVariant ? (0, _global_styling.mathWithUnits)([euiTheme.border.width.thick, euiTheme.border.width.thin], function (x, y) {
      return x + y;
    } // account for pseudo element border
    ) : form.stateUnderlineHeight, ",\n        transparent ").concat(form.stateUnderlineHeight, ",\n        transparent 100%\n      );\n    ") : '',
    // Windows high contrast mode overrides/hides background gradients - we'll need another approach
    forced: "\n      background-repeat: no-repeat;\n      background-size: 0% ".concat(form.stateUnderlineHeight, ";\n      background-position: bottom left;\n      background-origin: border-box;\n    ")
  });
  var backgroundAnimation = !isRefreshVariant ? "\n    ".concat(_global_styling.euiCanAnimate, " {\n      transition:\n        background-image ").concat(form.animationTiming, ",\n        background-size ").concat(form.animationTiming, ",\n        background-color ").concat(form.animationTiming, ";\n    }\n  ").trim() : '';
  return "\n    ".concat(withBorder ? border : '', "\n    ").concat(withBackgroundColor ? backgroundColor : '', "\n    ").concat(withBackground ? backgroundGradient : '', "\n    ").concat(withBackgroundAnimation ? backgroundAnimation : '', "\n  ");
};
var hoverSelector = '&:hover:not(:disabled, :focus, input[readonly], [class*="readOnly"])';
var disableFormControlHoverStyles = exports.disableFormControlHoverStyles = function disableFormControlHoverStyles() {
  return "\n  ".concat(hoverSelector, " {\n    outline: none;\n  }\n");
};
var euiFormControlHoverStyles = exports.euiFormControlHoverStyles = function euiFormControlHoverStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  var form = euiFormVariables(euiThemeContext);
  return "\n    ".concat(hoverSelector, " {\n      --borderWidthBase: var(--euiFormControlStateWidth, ").concat(euiTheme.border.width.thin, ");\n      --borderWidth: ").concat(highContrastMode ? euiTheme.border.width.thick : 'var(--borderWidthBase)', ";\n      --borderColor: var(--euiFormControlStateHoverColor, ").concat(highContrastMode ? euiTheme.border.color : form.borderHovered, ");\n      position: relative;\n      z-index: 1;\n      outline: var(--borderWidth) solid var(--borderColor);\n      outline-offset: calc(-1 * var(--borderWidth));\n    }\n  ");
};
var euiFormControlHighlightBorderStyles = exports.euiFormControlHighlightBorderStyles = "\n  position: relative;\n  z-index: 1;\n  box-shadow: none;\n  outline: var(--euiFormControlStateWidth) solid var(--euiFormControlStateColor);\n  outline-offset: calc(-1 * var(--euiFormControlStateWidth));\n";
var euiFormControlFocusStyles = exports.euiFormControlFocusStyles = function euiFormControlFocusStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var isRefreshVariant = (0, _services.isEuiThemeRefreshVariant)(euiThemeContext, 'formVariant');
  var form = euiFormVariables(euiThemeContext);
  var focusColor = euiTheme.colors.primary;
  return isRefreshVariant ? "\n      --euiFormControlStateColor: ".concat(form.borderFocused, ";\n      --euiFormControlStateHoverColor: ").concat(form.borderFocused, ";\n      --euiFormControlStateWidth: ").concat(euiTheme.border.width.thick, ";\n      ").concat(euiFormControlHighlightBorderStyles, "\n      ").concat((0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
    forced: "\n          ".concat(euiFormControlShowBackgroundLine(euiThemeContext, focusColor), "\n        ")
  }), "\n    ") : "\n      --euiFormControlStateColor: ".concat(focusColor, ";\n      background-color: ").concat(euiTheme.components.forms.backgroundFocused, ";\n      ").concat(euiFormControlShowBackgroundLine(euiThemeContext, focusColor), "\n      outline: none; /* Remove all outlines and rely on our own bottom border gradient */\n    ");
};
var euiFormControlInvalidStyles = exports.euiFormControlInvalidStyles = function euiFormControlInvalidStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  var isRefreshVariant = (0, _services.isEuiThemeRefreshVariant)(euiThemeContext, 'formVariant');
  var form = euiFormVariables(euiThemeContext);
  var invalidColor = euiTheme.colors.danger;
  return isRefreshVariant ? "\n      --euiFormControlStateColor: ".concat(form.borderInvalid, ";\n      --euiFormControlStateHoverColor: ").concat(form.borderInvalidHovered, ";\n      --euiFormControlStateWidth: ").concat(highContrastMode === 'preferred' ? euiTheme.border.width.thick : euiTheme.border.width.thin, ";\n\n      ").concat(euiFormControlHighlightBorderStyles, "\n      ").concat(euiFormControlShowBackgroundLine(euiThemeContext, invalidColor), "\n    ") : "\n      --euiFormControlStateColor: ".concat(invalidColor, ";\n      ").concat(euiFormControlShowBackgroundLine(euiThemeContext, invalidColor), "\n    ");
};
var euiFormControlDisabledStyles = exports.euiFormControlDisabledStyles = function euiFormControlDisabledStyles(euiThemeContext) {
  var isRefreshVariant = (0, _services.isEuiThemeRefreshVariant)(euiThemeContext, 'formVariant');
  var form = euiFormVariables(euiThemeContext);
  var refreshVariantStyles = "\n      --euiFormControlStateHoverColor: transparent;\n      --euiFormControlStateColor: ".concat(form.borderColor, ";\n    ");
  return "\n    color: ".concat(form.textColorDisabled, ";\n    /* Required for Safari */\n    -webkit-text-fill-color: ").concat(form.textColorDisabled, ";\n    background-color: ").concat(form.backgroundDisabledColor, ";\n    cursor: not-allowed;\n    --euiFormControlStateColor: transparent;\n\n    ").concat(isRefreshVariant && refreshVariantStyles, "\n\n    ").concat(euiPlaceholderPerBrowser(euiFormPlaceholderStyles(euiThemeContext)), "\n  ");
};
var euiFormControlReadOnlyStyles = exports.euiFormControlReadOnlyStyles = function euiFormControlReadOnlyStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var isRefreshVariant = (0, _services.isEuiThemeRefreshVariant)(euiThemeContext, 'formVariant');
  var form = euiFormVariables(euiThemeContext);
  var styles = isRefreshVariant ? "\n      --euiFormControlStateColor: ".concat(form.borderColor, ";\n      --euiFormControlStateHoverColor: ").concat(form.borderColor, ";\n      --euiFormControlStateWidth: ").concat(euiTheme.border.width.thin, ";\n      /* keep the input below wrapper borders */\n      position: relative;\n      z-index: 0;\n      outline: none;\n      box-shadow: inset 0 0 0 var(--euiFormControlStateWidth) var(--euiFormControlStateColor);\n\n      ").concat(formControlLayoutWrapperSelector, "[class*=inGroup] & {\n        box-shadow: none;\n      }\n      ").concat((0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
    preferred: 'box-shadow: none;'
  }), "\n    ") : "\n      --euiFormControlStateColor: transparent;\n      ".concat((0, _high_contrast.highContrastModeStyles)(euiThemeContext, {
    forced: 'background-image: none;'
  }), "\n    ");
  return "\n    background-color: ".concat(form.backgroundReadOnlyColor, ";\n    cursor: default;\n    color: ").concat(form.textColor, ";\n    -webkit-text-fill-color: ").concat(form.textColor, "; /* Required for Safari */\n\n    ").concat(styles, "\n  ");
};
var euiFormControlAutoFillStyles = exports.euiFormControlAutoFillStyles = function euiFormControlAutoFillStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme;
  var isRefreshVariant = (0, _services.isEuiThemeRefreshVariant)(euiThemeContext, 'formVariant');
  var form = euiFormVariables(euiThemeContext);

  // Make the text color slightly less prominent than the default colors.text
  var textColor = euiTheme.colors.darkestShade;
  var tintedBackgroundColor = euiTheme.components.forms.backgroundAutofilled;
  // Hacky workaround to background-color, since Chrome doesn't normally allow overriding its styles
  // @see https://developer.mozilla.org/en-US/docs/Web/CSS/:autofill#sect1
  var backgroundShadow = "inset 0 0 0 100vw ".concat(tintedBackgroundColor);

  // Re-create the border, since the above webkit box shadow overrides the default border box-shadow
  // + change the border color to match states, since the underline background gradient no longer works
  var borderColor = euiTheme.components.forms.borderAutofilled;
  var borderHovered = euiTheme.components.forms.borderAutofilledHovered;
  var borderInvalid = form.borderInvalid;
  var borderInvalidHovered = form.borderInvalidHovered;
  var borderShadow = function borderShadow(color) {
    return "inset 0 0 0 ".concat(euiTheme.border.width.thin, " ").concat(color);
  };
  var interactiveStyles = isRefreshVariant ? "\n      &:hover,\n      &:focus {\n        -webkit-box-shadow: ".concat(borderShadow(borderHovered), ", ").concat(backgroundShadow, ";\n      }\n\n      &:invalid {\n        -webkit-box-shadow: ").concat(borderShadow(borderInvalid), ", ").concat(backgroundShadow, ";\n\n        &:hover {\n          -webkit-box-shadow: ").concat(borderShadow(borderInvalidHovered), ", ").concat(backgroundShadow, ";\n        }\n      }\n    ") : "\n      &:invalid {\n          -webkit-box-shadow: ".concat(borderShadow(borderInvalid), ", ").concat(backgroundShadow, ";\n      }\n    ");

  // These styles only apply/override Chrome/webkit browsers - Firefox does not set autofill styles
  return "\n    &:-webkit-autofill {\n      -webkit-text-fill-color: ".concat(textColor, ";\n      -webkit-box-shadow: ").concat(borderShadow(borderColor), ", ").concat(backgroundShadow, ";\n\n      ").concat(interactiveStyles, "\n    }\n  ");
};
var euiFormControlShowBackgroundLine = exports.euiFormControlShowBackgroundLine = function euiFormControlShowBackgroundLine(euiThemeContext, color) {
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  var isRefreshVariant = (0, _services.isEuiThemeRefreshVariant)(euiThemeContext, 'formVariant');
  if (highContrastMode !== 'forced') {
    return 'background-size: 100% 100%;';
  }
  var _euiFormVariables = euiFormVariables(euiThemeContext),
    stateUnderlineHeight = _euiFormVariables.stateUnderlineHeight;

  // Windows high contrast themes ignore all background-images that aren't url-based,
  // so to restore the linear-gradient that provides important visual information, we're
  // using a static inline SVG workaround
  var fill = encodeURIComponent(color);
  var strokeWidth = stateUnderlineHeight !== null && stateUnderlineHeight !== void 0 ? stateUnderlineHeight : '4px';
  var inlineSVG = "data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg'%3E%3Crect width='100%25' height='100%25' fill='".concat(fill, "' /%3E%3C/svg%3E");
  var refreshInlineSVG = "data:image/svg+xml,%3Csvg xmlns='http://www.w3.org/2000/svg'%3E%3Crect width='100%25' height='100%25' style='fill:transparent;stroke-width:".concat(strokeWidth, ";stroke:").concat(fill, "' /%3E%3C/svg%3E");
  return isRefreshVariant ? "\n      background-size: calc(100% - ".concat((0, _global_styling.mathWithUnits)(strokeWidth, function (x) {
    return x / 2;
  }), ") calc(100% - ").concat((0, _global_styling.mathWithUnits)(strokeWidth, function (x) {
    return x / 2;
  }), ");\n      background-position: ").concat(euiTheme.border.width.thin, ";\n      background-image: url(\"").concat(refreshInlineSVG, "\");\n    ") : "\n    background-size: 100% ".concat(stateUnderlineHeight, ";\n    background-image: url(\"").concat(inlineSVG, "\");\n  ");
};
var euiPlaceholderPerBrowser = function euiPlaceholderPerBrowser(content) {
  return "\n  &::-webkit-input-placeholder { ".concat(content, " }\n  &::-moz-placeholder { ").concat(content, " }\n  &:-moz-placeholder { ").concat(content, " }\n  &::placeholder { ").concat(content, " }\n");
};

/**
 * Selection custom controls - checkboxes, radios, and switches
 */

var euiFormCustomControlVariables = exports.euiFormCustomControlVariables = function euiFormCustomControlVariables(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  var sizes = {
    control: euiTheme.size.base,
    lineHeight: euiTheme.size.l,
    labelGap: euiTheme.size.s
  };
  var colors = {
    unselected: euiTheme.components.forms.controlBackgroundUnselected,
    unselectedBorder: highContrastMode ? euiTheme.border.color : euiTheme.components.forms.controlBorder,
    selected: euiTheme.colors.primary,
    selectedBorder: euiTheme.components.forms.controlBorderSelected,
    selectedIcon: euiTheme.colors.emptyShade,
    disabled: euiTheme.components.forms.controlBackgroundDisabled,
    disabledBorder: euiTheme.components.forms.controlBorderDisabled,
    disabledIcon: euiTheme.components.forms.iconDisabled,
    disabledLabel: euiTheme.colors.textDisabled // Lighter than formVars.disabledColor because it typically doesn't have as dark a background
  };
  var animation = {
    speed: euiTheme.animation.fast,
    easing: 'ease-in'
  };
  return {
    sizes: sizes,
    colors: colors,
    animation: animation
  };
};
var euiFormCustomControlStyles = exports.euiFormCustomControlStyles = function euiFormCustomControlStyles(euiThemeContext) {
  var euiTheme = euiThemeContext.euiTheme,
    highContrastMode = euiThemeContext.highContrastMode;
  var controlVars = euiFormCustomControlVariables(euiThemeContext);
  var centerWithLabel = (0, _global_styling.mathWithUnits)([controlVars.sizes.lineHeight, controlVars.sizes.control], function (x, y) {
    return (x - y) / 2;
  });
  return {
    wrapper: "\n      display: flex;\n      align-items: flex-start;\n    ",
    input: {
      fauxInput: "\n        position: relative;\n        ".concat((0, _global_styling.logicalCSS)('height', controlVars.sizes.control), "\n        ").concat((0, _global_styling.logicalCSS)('width', controlVars.sizes.control), "\n        display: flex;\n        justify-content: center;\n        align-items: center;\n        /* For Windows high contrast themes, a border must always be rendered, not just a background */\n        border: ").concat(euiTheme.border.width.thin, " solid transparent;\n\n        &:has(input:focus-visible) {\n          outline: ").concat(euiTheme.focus.width, " solid ").concat(controlVars.colors.selected, ";\n          outline-offset: ").concat(euiTheme.focus.width, ";\n        }\n\n        ").concat(_global_styling.euiCanAnimate, " {\n          transition-property: background-color, color;\n          transition-duration: ").concat(controlVars.animation.speed, ";\n          transition-timing-function: ").concat(controlVars.animation.easing, ";\n        }\n      "),
      // TODO: Revert https://github.com/elastic/eui/pull/7981
      // once https://github.com/dperini/nwsapi/issues/123
      // has been fixed, and restore `&:has(+ label)` selector
      hasLabel: "\n        ".concat((0, _global_styling.logicalCSS)('margin-top', centerWithLabel), "\n      "),
      enabled: {
        selected: "\n          color: ".concat(controlVars.colors.selectedIcon, ";\n          background-color: ").concat(controlVars.colors.selected, ";\n          border-color: ").concat(controlVars.colors.selected, ";\n        "),
        unselected: "\n          color: transparent;\n          background-color: ".concat(controlVars.colors.unselected, ";\n          border-color: ").concat(controlVars.colors.unselectedBorder, ";\n\n          &:has(input:focus) {\n            border-color: ").concat(controlVars.colors.selected, ";\n          }\n        ")
      },
      disabled: {
        get shared() {
          var borderColor = highContrastMode ? controlVars.colors.disabledIcon : controlVars.colors.disabled;
          return "\n            label: disabled;\n            cursor: not-allowed;\n            background-color: ".concat(controlVars.colors.disabled, ";\n            border-color: ").concat(borderColor, ";\n          ");
        },
        get selected() {
          return "\n            ".concat(this.shared, "\n            color: ").concat(controlVars.colors.disabledIcon, ";\n          ");
        },
        get unselected() {
          return "\n            ".concat(this.shared, "\n            color: ").concat(controlVars.colors.disabled, ";\n          ");
        }
      },
      // Looks better centered at different zoom levels than just <EuiIcon size="s" />
      icon: "\n        transform: scale(0.75);\n      ",
      // Hidden input sits on top of the visible element
      hiddenInput: "\n        position: absolute;\n        inset: 0;\n        opacity: 0 !important;\n        cursor: pointer;\n\n        &:disabled {\n          cursor: not-allowed;\n        }\n      "
    },
    label: {
      label: "\n        /* Needs to use padding and not flex gap for extra mouse click area */\n        ".concat((0, _global_styling.logicalCSS)('padding-left', controlVars.sizes.labelGap), "\n        line-height: ").concat(controlVars.sizes.lineHeight, ";\n        font-size: ").concat((0, _global_styling.euiFontSize)(euiThemeContext, 's').fontSize, ";\n      "),
      enabled: "\n        cursor: pointer;\n      ",
      disabled: "\n        cursor: not-allowed;\n        color: ".concat(controlVars.colors.disabledLabel, ";\n      ")
    }
  };
};