"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.EuiRecentlyUsed = void 0;
var _react = _interopRequireDefault(require("react"));
var _propTypes = _interopRequireDefault(require("prop-types"));
var _services = require("../../../../services");
var _i18n = require("../../../i18n");
var _flex = require("../../../flex");
var _link = require("../../../link");
var _pretty_duration = require("../pretty_duration");
var _quick_select_panel = require("./quick_select_panel");
var _react2 = require("@emotion/react");
function _interopRequireDefault(e) { return e && e.__esModule ? e : { default: e }; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */

var EuiRecentlyUsed = exports.EuiRecentlyUsed = function EuiRecentlyUsed(_ref) {
  var applyTime = _ref.applyTime,
    commonlyUsedRanges = _ref.commonlyUsedRanges,
    dateFormat = _ref.dateFormat,
    _ref$recentlyUsedRang = _ref.recentlyUsedRanges,
    recentlyUsedRanges = _ref$recentlyUsedRang === void 0 ? [] : _ref$recentlyUsedRang;
  var title = (0, _i18n.useEuiI18n)('euiRecentlyUsed.legend', 'Recently used date ranges');
  var legendId = (0, _services.useGeneratedHtmlId)();
  if (recentlyUsedRanges.length === 0) {
    return null;
  }
  var links = recentlyUsedRanges.map(function (_ref2) {
    var start = _ref2.start,
      end = _ref2.end;
    var applyRecentlyUsed = function applyRecentlyUsed() {
      applyTime({
        start: start,
        end: end
      });
    };
    return (0, _react2.jsx)(_flex.EuiFlexItem, {
      component: "li",
      key: "".concat(start, "-").concat(end)
    }, (0, _react2.jsx)(_link.EuiLink, {
      onClick: applyRecentlyUsed
    }, (0, _react2.jsx)(_pretty_duration.PrettyDuration, {
      timeFrom: start,
      timeTo: end,
      quickRanges: commonlyUsedRanges,
      dateFormat: dateFormat
    })));
  });
  return (0, _react2.jsx)(_quick_select_panel.EuiQuickSelectPanel, {
    component: "fieldset",
    titleId: legendId,
    title: title
  }, (0, _react2.jsx)(_flex.EuiFlexGroup, {
    component: "ul",
    gutterSize: "s",
    direction: "column"
  }, links));
};
EuiRecentlyUsed.propTypes = {
  applyTime: _propTypes.default.func.isRequired,
  commonlyUsedRanges: _propTypes.default.arrayOf(_propTypes.default.shape({
    end: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired,
    label: _propTypes.default.string,
    start: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired
  }).isRequired).isRequired,
  dateFormat: _propTypes.default.string.isRequired,
  recentlyUsedRanges: _propTypes.default.arrayOf(_propTypes.default.shape({
    end: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired,
    label: _propTypes.default.string,
    start: _propTypes.default.oneOfType([_propTypes.default.oneOf(["now"]), _propTypes.default.string.isRequired]).isRequired
  }).isRequired)
};
EuiRecentlyUsed.displayName = 'EuiRecentlyUsed';