"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.raw_data = exports.defaultStorybookArgs = exports.StatefulDataGrid = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _faker = require("@faker-js/faker");
var _link = require("../link");
var _accessibility = require("../accessibility");
var _button = require("../button");
var _form = require("../form");
var _badge = require("../badge");
var _data_grid_toolbar = require("./controls/data_grid_toolbar");
var _data_grid = require("./data_grid");
var _excluded = ["pagination", "sorting", "columnVisibility"];
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function _getRequireWildcardCache(e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != _typeof(e) && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function _extends() { return _extends = Object.assign ? Object.assign.bind() : function (n) { for (var e = 1; e < arguments.length; e++) { var t = arguments[e]; for (var r in t) ({}).hasOwnProperty.call(t, r) && (n[r] = t[r]); } return n; }, _extends.apply(null, arguments); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); }
function _slicedToArray(r, e) { return _arrayWithHoles(r) || _iterableToArrayLimit(r, e) || _unsupportedIterableToArray(r, e) || _nonIterableRest(); }
function _nonIterableRest() { throw new TypeError("Invalid attempt to destructure non-iterable instance.\nIn order to be iterable, non-array objects must have a [Symbol.iterator]() method."); }
function _unsupportedIterableToArray(r, a) { if (r) { if ("string" == typeof r) return _arrayLikeToArray(r, a); var t = {}.toString.call(r).slice(8, -1); return "Object" === t && r.constructor && (t = r.constructor.name), "Map" === t || "Set" === t ? Array.from(r) : "Arguments" === t || /^(?:Ui|I)nt(?:8|16|32)(?:Clamped)?Array$/.test(t) ? _arrayLikeToArray(r, a) : void 0; } }
function _arrayLikeToArray(r, a) { (null == a || a > r.length) && (a = r.length); for (var e = 0, n = Array(a); e < a; e++) n[e] = r[e]; return n; }
function _iterableToArrayLimit(r, l) { var t = null == r ? null : "undefined" != typeof Symbol && r[Symbol.iterator] || r["@@iterator"]; if (null != t) { var e, n, i, u, a = [], f = !0, o = !1; try { if (i = (t = t.call(r)).next, 0 === l) { if (Object(t) !== t) return; f = !1; } else for (; !(f = (e = i.call(t)).done) && (a.push(e.value), a.length !== l); f = !0); } catch (r) { o = !0, n = r; } finally { try { if (!f && null != t.return && (u = t.return(), Object(u) !== u)) return; } finally { if (o) throw n; } } return a; } }
function _arrayWithHoles(r) { if (Array.isArray(r)) return r; }
function _objectWithoutProperties(e, t) { if (null == e) return {}; var o, r, i = _objectWithoutPropertiesLoose(e, t); if (Object.getOwnPropertySymbols) { var n = Object.getOwnPropertySymbols(e); for (r = 0; r < n.length; r++) o = n[r], t.indexOf(o) >= 0 || {}.propertyIsEnumerable.call(e, o) && (i[o] = e[o]); } return i; }
function _objectWithoutPropertiesLoose(r, e) { if (null == r) return {}; var t = {}; for (var n in r) if ({}.hasOwnProperty.call(r, n)) { if (e.indexOf(n) >= 0) continue; t[n] = r[n]; } return t; }
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function _EMOTION_STRINGIFIED_CSS_ERROR__() { return "You have tried to stringify object returned from `css` function. It isn't supposed to be used directly (e.g. as value of the `className` prop), but rather handed to emotion so it can handle it (e.g. as value of `css` prop)."; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */ /* eslint-disable storybook/default-exports, storybook/prefer-pascal-case */
_faker.faker.seed(42);

// NOTE: using faker.date.past() is not fully stable for VRT as the date is
// based on a years time distance (default 1 year) which updates with progressing time
// faker.seed() ensures the same date is output in the same time frame
// but after some time the time distance will generate a newer, closer date
// which then invalidates the VRT
var staticDates = [new Date('Tue Mar 19 2024 18:54:51 GMT+0100'), new Date('Mon Mar 25 2024 19:27:35 GMT+0100'), new Date('Sat Sep 09 2023 00:32:42 GMT+0200'), new Date('Wed Jun 14 2023 06:48:29 GMT+0200'), new Date('Mon Mar 04 2024 04:40:36 GMT+0100'), new Date('Mon Feb 05 2024 10:51:48 GMT+0100'), new Date('Mon Jun 19 2023 12:08:38 GMT+0200'), new Date('Wed Jul 26 2023 01:15:02 GMT+0200'), new Date('Wed Nov 08 2023 08:49:13 GMT+0100'), new Date('Sun Nov 19 2023 01:49:12 GMT+0100')];
var dataKeys = ['name', 'email', 'account', 'location', 'date', 'version'];
var _ref = process.env.NODE_ENV === "production" ? {
  name: "1u596ek-version",
  styles: "vertical-align:text-bottom;label:version;"
} : {
  name: "1u596ek-version",
  styles: "vertical-align:text-bottom;label:version;",
  toString: _EMOTION_STRINGIFIED_CSS_ERROR__
};
var raw_data = exports.raw_data = Array.from({
  length: 10
}).map(function (_, i) {
  var email = _faker.faker.internet.email();
  var name = "".concat(_faker.faker.person.lastName(), ", ").concat(_faker.faker.person.firstName());
  var date = staticDates[i].toDateString();
  var suffix = _faker.faker.person.suffix();
  return {
    name: {
      formatted: "".concat(name, " ").concat(suffix),
      raw: name
    },
    email: {
      formatted: (0, _react2.jsx)(_link.EuiLink, {
        href: ""
      }, email),
      raw: email
    },
    location: (0, _react2.jsx)(_react.default.Fragment, null, "".concat(_faker.faker.location.city(), ", "), (0, _react2.jsx)(_link.EuiLink, {
      href: "https://google.com"
    }, _faker.faker.location.country())),
    date: date,
    account: _faker.faker.finance.accountNumber(),
    version: (0, _react2.jsx)(_badge.EuiBadge
    // Tweak the badge's vertical centering
    , {
      css: _ref
    }, _faker.faker.system.semver())
  };
});
var columns = [{
  id: 'name',
  displayAsText: 'Name',
  defaultSortDirection: 'asc',
  cellActions: [function (_ref2) {
    var rowIndex = _ref2.rowIndex,
      Component = _ref2.Component;
    var data = raw_data;
    var value = data[rowIndex].name.raw;
    return (0, _react2.jsx)(Component, {
      onClick: function onClick() {
        return alert("Hi ".concat(value));
      },
      iconType: "heart",
      "aria-label": "Say hi to ".concat(value, "!")
    }, "Say hi");
  }]
}, {
  id: 'email',
  displayAsText: 'Email address',
  initialWidth: 130,
  cellActions: [function (_ref3) {
    var rowIndex = _ref3.rowIndex,
      Component = _ref3.Component;
    var data = raw_data;
    var value = data[rowIndex].email.raw;
    return (0, _react2.jsx)(Component, {
      onClick: function onClick() {
        return alert(value);
      },
      iconType: "email",
      "aria-label": "Send email to ".concat(value)
    }, "Send email");
  }]
}, {
  id: 'account',
  displayAsText: 'Account',
  actions: {
    showHide: {
      label: 'Custom hide label'
    },
    showMoveLeft: false,
    showMoveRight: false,
    additional: [{
      label: 'Custom action',
      onClick: function onClick() {},
      iconType: 'cheer',
      size: 'xs',
      color: 'text'
    }]
  },
  cellActions: [function (_ref4) {
    var rowIndex = _ref4.rowIndex,
      Component = _ref4.Component,
      isExpanded = _ref4.isExpanded;
    var data = raw_data;
    var value = data[rowIndex].account;
    var onClick = isExpanded ? function () {
      return alert("Sent money to ".concat(value, " when expanded"));
    } : function () {
      return alert("Sent money to ".concat(value, " when not expanded"));
    };
    return (0, _react2.jsx)(Component, {
      onClick: onClick,
      iconType: "faceHappy",
      "aria-label": "Send money to ".concat(value)
    }, "Send money");
  }]
}, {
  id: 'location',
  displayAsText: 'Location'
}, {
  id: 'date',
  displayAsText: 'Date',
  defaultSortDirection: 'desc'
}, {
  id: 'version',
  displayAsText: 'Version',
  defaultSortDirection: 'desc',
  initialWidth: 70,
  isResizable: false,
  actions: false,
  schema: 'version' // Custom schema + CSS
}];
var RenderCellValue = function RenderCellValue(_ref5) {
  var rowIndex = _ref5.rowIndex,
    columnId = _ref5.columnId;
  var data = raw_data;
  var row = data[rowIndex];
  var columnName = columnId;
  var column = row[columnName];
  var getFormatted = function getFormatted() {
    if (_typeof(column) === 'object') {
      var hasFormatted = ('formatted' in column);
      return hasFormatted ? column.formatted : column;
    }
    return typeof column === 'string' ? column : null;
  };
  return data.hasOwnProperty(rowIndex) ? getFormatted() : null;
};
var defaultStorybookArgs = exports.defaultStorybookArgs = {
  'aria-label': 'EuiDataGrid',
  css: process.env.NODE_ENV === "production" ? {
    name: "1h7lf59-css",
    styles: ".euiDataGridRowCell--version,.euiDataGridHeaderCell--version{text-align:center;};label:css;"
  } : {
    name: "1h7lf59-css",
    styles: ".euiDataGridRowCell--version,.euiDataGridHeaderCell--version{text-align:center;};label:css;",
    toString: _EMOTION_STRINGIFIED_CSS_ERROR__
  },
  columns: columns,
  rowCount: 10,
  renderCellValue: RenderCellValue,
  trailingControlColumns: [{
    id: 'trailing-actions',
    width: 64,
    headerCellRender: function headerCellRender() {
      return (0, _react2.jsx)(_accessibility.EuiScreenReaderOnly, null, (0, _react2.jsx)("span", null, "Row actions"));
    },
    rowCellRender: function rowCellRender() {
      return (0, _react2.jsx)(_react.default.Fragment, null, (0, _react2.jsx)(_button.EuiButtonIcon, {
        iconType: "indexEdit",
        "aria-label": "Edit row"
      }), (0, _react2.jsx)(_button.EuiButtonIcon, {
        iconType: "boxesHorizontal",
        "aria-label": "Open actions popover"
      }));
    }
  }],
  leadingControlColumns: [{
    id: 'leading-actions',
    width: 32,
    headerCellRender: function headerCellRender() {
      return (0, _react2.jsx)(_form.EuiCheckbox, {
        id: "selectAll",
        "aria-label": "Select all rows",
        onChange: function onChange() {}
      });
    },
    rowCellRender: function rowCellRender(_ref6) {
      var rowIndex = _ref6.rowIndex;
      return (0, _react2.jsx)(_form.EuiCheckbox, {
        id: "selectRow".concat(rowIndex),
        "aria-label": "Select row ".concat(rowIndex + 1),
        onChange: function onChange() {}
      });
    }
  }],
  // setup for easier testing/QA
  columnVisibility: {
    visibleColumns: ['name', 'email', 'account', 'location', 'date', 'amount', 'phone', 'version'],
    setVisibleColumns: function setVisibleColumns() {},
    canDragAndDropColumns: false
  },
  inMemory: {
    level: 'sorting'
  },
  pagination: {
    pageIndex: 0,
    pageSize: 10,
    pageSizeOptions: [10, 20, 50],
    onChangeItemsPerPage: function onChangeItemsPerPage() {},
    onChangePage: function onChangePage() {}
  },
  gridStyle: {
    fontSize: 'm',
    cellPadding: 'm',
    border: 'all',
    stripes: false,
    header: 'shade',
    footer: 'overline',
    stickyFooter: true,
    rowHover: 'highlight',
    rowClasses: {}
  },
  width: '',
  height: '',
  toolbarVisibility: {
    showColumnSelector: true,
    showDisplaySelector: true,
    showSortSelector: true,
    showKeyboardShortcuts: true,
    showFullScreenSelector: true,
    additionalControls: null
  },
  minSizeForControls: _data_grid_toolbar.MINIMUM_WIDTH_FOR_GRID_CONTROLS,
  rowHeightsOptions: {
    defaultHeight: undefined,
    rowHeights: {},
    lineHeight: undefined,
    scrollAnchorRow: undefined
  }
};
var StatefulDataGrid = exports.StatefulDataGrid = function StatefulDataGrid(props) {
  var _pagination$pageIndex, _sorting$columns, _columnVisibility$vis;
  var pagination = props.pagination,
    sorting = props.sorting,
    columnVisibility = props.columnVisibility,
    rest = _objectWithoutProperties(props, _excluded);

  // Pagination
  var _useState = (0, _react.useState)(_objectSpread({
      pageIndex: (_pagination$pageIndex = pagination === null || pagination === void 0 ? void 0 : pagination.pageIndex) !== null && _pagination$pageIndex !== void 0 ? _pagination$pageIndex : 0
    }, pagination)),
    _useState2 = _slicedToArray(_useState, 2),
    _pagination = _useState2[0],
    setPagination = _useState2[1];
  var onChangeItemsPerPage = (0, _react.useCallback)(function (pageSize) {
    return setPagination(function (pagination) {
      return _objectSpread(_objectSpread({}, pagination), {}, {
        pageSize: pageSize,
        pageIndex: 0
      });
    });
  }, [setPagination]);
  var onChangePage = (0, _react.useCallback)(function (pageIndex) {
    return setPagination(function (pagination) {
      return _objectSpread(_objectSpread({}, pagination), {}, {
        pageIndex: pageIndex
      });
    });
  }, [setPagination]);
  (0, _react.useEffect)(function () {
    if (pagination) {
      setPagination(function (curentPagination) {
        return _objectSpread(_objectSpread({}, curentPagination), pagination);
      });
    }
  }, [pagination]);

  // Sorting
  var _useState3 = (0, _react.useState)((_sorting$columns = sorting === null || sorting === void 0 ? void 0 : sorting.columns) !== null && _sorting$columns !== void 0 ? _sorting$columns : []),
    _useState4 = _slicedToArray(_useState3, 2),
    sortingColumns = _useState4[0],
    setSortingColumns = _useState4[1];
  var onSort = (0, _react.useCallback)(function (sortingColumns) {
    var _sorting$onSort;
    setSortingColumns(sortingColumns);
    sorting === null || sorting === void 0 || (_sorting$onSort = sorting.onSort) === null || _sorting$onSort === void 0 || _sorting$onSort.call(sorting, sortingColumns);
  }, [setSortingColumns, sorting]);
  (0, _react.useEffect)(function () {
    if (sorting && Array.isArray(sorting.columns)) {
      setSortingColumns(sorting.columns);
    }
  }, [sorting]);

  // Column visibility
  var _useState5 = (0, _react.useState)((_columnVisibility$vis = columnVisibility === null || columnVisibility === void 0 ? void 0 : columnVisibility.visibleColumns) !== null && _columnVisibility$vis !== void 0 ? _columnVisibility$vis : columns.map(function (_ref7) {
      var id = _ref7.id;
      return id;
    }) // initialize to the full set of columns
    ),
    _useState6 = _slicedToArray(_useState5, 2),
    visibleColumns = _useState6[0],
    setVisibleColumns = _useState6[1];
  (0, _react.useEffect)(function () {
    if ((columnVisibility === null || columnVisibility === void 0 ? void 0 : columnVisibility.visibleColumns) != null) {
      setVisibleColumns(columnVisibility === null || columnVisibility === void 0 ? void 0 : columnVisibility.visibleColumns);
    }
  }, [columnVisibility]);
  return (0, _react2.jsx)(_data_grid.EuiDataGrid, _extends({}, rest, {
    columnVisibility: {
      visibleColumns: visibleColumns,
      setVisibleColumns: setVisibleColumns,
      canDragAndDropColumns: columnVisibility.canDragAndDropColumns
    },
    sorting: {
      columns: sortingColumns,
      onSort: onSort
    },
    pagination: _objectSpread(_objectSpread({}, _pagination), {}, {
      onChangeItemsPerPage: onChangeItemsPerPage,
      onChangePage: onChangePage
    })
  }));
};