"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.shadows = exports.shadowPrimitives = void 0;
var _euiThemeCommon = require("@elastic/eui-theme-common");
var _semantic_colors = require("./colors/_semantic_colors");
var _primitive_colors = require("./colors/_primitive_colors");
function _typeof(o) { "@babel/helpers - typeof"; return _typeof = "function" == typeof Symbol && "symbol" == typeof Symbol.iterator ? function (o) { return typeof o; } : function (o) { return o && "function" == typeof Symbol && o.constructor === Symbol && o !== Symbol.prototype ? "symbol" : typeof o; }, _typeof(o); }
function ownKeys(e, r) { var t = Object.keys(e); if (Object.getOwnPropertySymbols) { var o = Object.getOwnPropertySymbols(e); r && (o = o.filter(function (r) { return Object.getOwnPropertyDescriptor(e, r).enumerable; })), t.push.apply(t, o); } return t; }
function _objectSpread(e) { for (var r = 1; r < arguments.length; r++) { var t = null != arguments[r] ? arguments[r] : {}; r % 2 ? ownKeys(Object(t), !0).forEach(function (r) { _defineProperty(e, r, t[r]); }) : Object.getOwnPropertyDescriptors ? Object.defineProperties(e, Object.getOwnPropertyDescriptors(t)) : ownKeys(Object(t)).forEach(function (r) { Object.defineProperty(e, r, Object.getOwnPropertyDescriptor(t, r)); }); } return e; }
function _defineProperty(e, r, t) { return (r = _toPropertyKey(r)) in e ? Object.defineProperty(e, r, { value: t, enumerable: !0, configurable: !0, writable: !0 }) : e[r] = t, e; }
function _toPropertyKey(t) { var i = _toPrimitive(t, "string"); return "symbol" == _typeof(i) ? i : i + ""; }
function _toPrimitive(t, r) { if ("object" != _typeof(t) || !t) return t; var e = t[Symbol.toPrimitive]; if (void 0 !== e) { var i = e.call(t, r || "default"); if ("object" != _typeof(i)) return i; throw new TypeError("@@toPrimitive must return a primitive value."); } return ("string" === r ? String : Number)(t); } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0 and the Server Side Public License, v 1; you may not use this file except
 * in compliance with, at your election, the Elastic License 2.0 or the Server
 * Side Public License, v 1.
 */
/**
 * This structure holds "primitives" (or actual design tokens as they
 * would be stored in a design token repository).
 * Not exposing them in the theme object is intentional.
 */
var shadowPrimitives = exports.shadowPrimitives = {
  xs: {
    light: [{
      opacity: 0.16,
      x: 0,
      y: 0,
      blur: 2,
      spread: 0
    }, {
      opacity: 0.06,
      x: 0,
      y: 1,
      blur: 4,
      spread: 0
    }, {
      opacity: 0.04,
      x: 0,
      y: 2,
      blur: 8,
      spread: 0
    }],
    dark: [{
      opacity: 1,
      x: 0,
      y: 0,
      blur: 0,
      spread: 1
    }, {
      opacity: 0.4,
      x: 0,
      y: 1,
      blur: 4,
      spread: 0
    }, {
      opacity: 0.24,
      x: 0,
      y: 2,
      blur: 8,
      spread: 0
    }]
  },
  s: {
    light: [{
      opacity: 0.16,
      x: 0,
      y: 0,
      blur: 2,
      spread: 0
    }, {
      opacity: 0.08,
      x: 0,
      y: 2,
      blur: 7,
      spread: 0
    }, {
      opacity: 0.05,
      x: 0,
      y: 4,
      blur: 11,
      spread: 0
    }],
    dark: [{
      opacity: 1,
      x: 0,
      y: 0,
      blur: 0,
      spread: 1
    }, {
      opacity: 0.46,
      x: 0,
      y: 2,
      blur: 7,
      spread: 0
    }, {
      opacity: 0.26,
      x: 0,
      y: 4,
      blur: 11,
      spread: 0
    }]
  },
  m: {
    light: [{
      opacity: 0.16,
      x: 0,
      y: 0,
      blur: 2,
      spread: 0
    }, {
      opacity: 0.1,
      x: 0,
      y: 3,
      blur: 10,
      spread: 0
    }, {
      opacity: 0.06,
      x: 0,
      y: 6,
      blur: 14,
      spread: 0
    }],
    dark: [{
      opacity: 1,
      x: 0,
      y: 0,
      blur: 0,
      spread: 1
    }, {
      opacity: 0.52,
      x: 0,
      y: 3,
      blur: 10,
      spread: 0
    }, {
      opacity: 0.28,
      x: 0,
      y: 6,
      blur: 14,
      spread: 0
    }]
  },
  l: {
    light: [{
      opacity: 0.16,
      x: 0,
      y: 0,
      blur: 2,
      spread: 0
    }, {
      opacity: 0.12,
      x: 0,
      y: 4,
      blur: 13,
      spread: 0
    }, {
      opacity: 0.07,
      x: 0,
      y: 8,
      blur: 17,
      spread: 0
    }],
    dark: [{
      opacity: 1,
      x: 0,
      y: 0,
      blur: 0,
      spread: 1
    }, {
      opacity: 0.58,
      x: 0,
      y: 4,
      blur: 13,
      spread: 0
    }, {
      opacity: 0.3,
      x: 0,
      y: 8,
      blur: 17,
      spread: 0
    }]
  },
  xl: {
    light: [{
      opacity: 0.16,
      x: 0,
      y: 0,
      blur: 2,
      spread: 0
    }, {
      opacity: 0.14,
      x: 0,
      y: 5,
      blur: 16,
      spread: 0
    }, {
      opacity: 0.08,
      x: 0,
      y: 10,
      blur: 20,
      spread: 0
    }],
    dark: [{
      opacity: 1,
      x: 0,
      y: 0,
      blur: 0,
      spread: 1
    }, {
      opacity: 0.64,
      x: 0,
      y: 5,
      blur: 16,
      spread: 0
    }, {
      opacity: 0.32,
      x: 0,
      y: 10,
      blur: 20,
      spread: 0
    }]
  },
  xxl: {
    light: [{
      opacity: 0.16,
      x: 0,
      y: 0,
      blur: 2,
      spread: 0
    }, {
      opacity: 0.16,
      x: 0,
      y: 6,
      blur: 19,
      spread: 0
    }, {
      opacity: 0.09,
      x: 0,
      y: 12,
      blur: 23,
      spread: 0
    }],
    dark: [{
      opacity: 1,
      x: 0,
      y: 0,
      blur: 0,
      spread: 1
    }, {
      opacity: 0.7,
      x: 0,
      y: 6,
      blur: 19,
      spread: 0
    }, {
      opacity: 0.34,
      x: 0,
      y: 12,
      blur: 23,
      spread: 0
    }]
  },
  flat: {
    light: [],
    dark: []
  }
};
var shadowColorsLight = {
  colors: {
    base: _semantic_colors.SEMANTIC_COLORS.shade120
  }
};
var shadowsLight = _objectSpread(_objectSpread({}, shadowColorsLight), {}, {
  xs: {
    down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.xs.light, {
      color: shadowColorsLight.colors.base
    }),
    up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.xs.light, {
      direction: 'up',
      color: shadowColorsLight.colors.base
    })
  },
  s: {
    down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.s.light, {
      color: shadowColorsLight.colors.base
    }),
    up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.s.light, {
      direction: 'up',
      color: shadowColorsLight.colors.base
    })
  },
  m: {
    down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.m.light, {
      color: shadowColorsLight.colors.base
    }),
    up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.m.light, {
      direction: 'up',
      color: shadowColorsLight.colors.base
    })
  },
  l: {
    down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.l.light, {
      color: shadowColorsLight.colors.base
    }),
    up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.l.light, {
      direction: 'up',
      color: shadowColorsLight.colors.base
    })
  },
  xl: {
    down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.xl.light, {
      color: shadowColorsLight.colors.base
    }),
    up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.xl.light, {
      direction: 'up',
      color: shadowColorsLight.colors.base
    })
  },
  hover: {
    base: {
      down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.s.light, {
        color: shadowColorsLight.colors.base
      }),
      up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.s.light, {
        direction: 'up',
        color: shadowColorsLight.colors.base
      })
    },
    xl: {
      down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.xxl.light, {
        color: shadowColorsLight.colors.base
      }),
      up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.xxl.light, {
        direction: 'up',
        color: shadowColorsLight.colors.base
      })
    }
  },
  flat: {
    down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.xs.light, {
      color: shadowColorsLight.colors.base
    }),
    up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.xs.light, {
      direction: 'up',
      color: shadowColorsLight.colors.base
    })
  }
});
var shadowColorsDark = {
  colors: {
    base: _primitive_colors.PRIMITIVE_COLORS.black
  }
};
var shadowsDark = _objectSpread(_objectSpread({}, shadowColorsDark), {}, {
  xs: {
    down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.xs.dark.slice(1), {
      color: shadowColorsDark.colors.base
    }),
    up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.xs.dark.slice(1), {
      direction: 'up',
      color: shadowColorsDark.colors.base
    })
  },
  s: {
    down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.s.dark.slice(1), {
      color: shadowColorsDark.colors.base
    }),
    up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.s.dark.slice(1), {
      direction: 'up',
      color: shadowColorsDark.colors.base
    })
  },
  m: {
    down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.m.dark.slice(1), {
      color: shadowColorsDark.colors.base
    }),
    up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.m.dark.slice(1), {
      direction: 'up',
      color: shadowColorsDark.colors.base
    })
  },
  l: {
    down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.l.dark.slice(1), {
      color: shadowColorsDark.colors.base
    }),
    up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.l.dark.slice(1), {
      direction: 'up',
      color: shadowColorsDark.colors.base
    })
  },
  xl: {
    down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.xl.dark.slice(1), {
      color: shadowColorsDark.colors.base
    }),
    up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.xl.dark.slice(1), {
      direction: 'up',
      color: shadowColorsDark.colors.base
    })
  },
  hover: {
    base: {
      down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.s.dark.slice(1), {
        color: shadowColorsDark.colors.base
      }),
      up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.s.dark.slice(1), {
        direction: 'up',
        color: shadowColorsDark.colors.base
      })
    },
    xl: {
      down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.xxl.dark.slice(1), {
        color: shadowColorsDark.colors.base
      }),
      up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.xxl.dark.slice(1), {
        direction: 'up',
        color: shadowColorsDark.colors.base
      })
    }
  },
  flat: {
    down: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.xs.dark.slice(1), {
      color: shadowColorsDark.colors.base
    }),
    up: (0, _euiThemeCommon.formatMultipleBoxShadow)(shadowPrimitives.xs.dark.slice(1), {
      direction: 'up',
      color: shadowColorsDark.colors.base
    })
  }
});
var shadows = exports.shadows = {
  LIGHT: shadowsLight,
  DARK: shadowsDark
};