"use strict";
Object.defineProperty(exports, "__esModule", { value: true });
exports.renderHeatmapDebugElements = void 0;
const color_library_wrappers_1 = require("../../../../common/color_library_wrappers");
const colors_1 = require("../../../../common/colors");
const debug_1 = require("../../../../renderers/canvas/utils/debug");
const renderDebugMargins = (ctx, container, margins) => {
    const greenSemiTransparent = (0, color_library_wrappers_1.overrideOpacity)(colors_1.Colors.Green.rgba, 0.5);
    (0, debug_1.renderDebugRect)(ctx, {
        x: container.left,
        y: container.top,
        width: margins.left,
        height: container.height,
    }, 0, { color: greenSemiTransparent });
    (0, debug_1.renderDebugRect)(ctx, {
        x: container.left + container.width - margins.right,
        y: container.top,
        width: margins.right,
        height: container.height,
    }, 0, { color: greenSemiTransparent });
    (0, debug_1.renderDebugRect)(ctx, {
        x: container.left,
        y: container.top,
        width: container.width,
        height: margins.top,
    }, 0, { color: greenSemiTransparent });
    (0, debug_1.renderDebugRect)(ctx, {
        x: container.left,
        y: container.top + container.height - margins.bottom,
        width: container.width,
        height: margins.bottom,
    }, 0, { color: greenSemiTransparent });
};
const renderDebugPaddings = (ctx, conatiner, chart, margins, paddings) => {
    const lightBlueSemiTransparent = (0, color_library_wrappers_1.overrideOpacity)(colors_1.Colors.LightBlue.rgba, 0.5);
    (0, debug_1.renderDebugRect)(ctx, {
        x: chart.left - paddings.left,
        y: conatiner.top + paddings.top + margins.top,
        width: paddings.left,
        height: chart.height,
    }, 0, { color: lightBlueSemiTransparent });
    (0, debug_1.renderDebugRect)(ctx, {
        x: conatiner.left + conatiner.width - paddings.right - margins.right,
        y: conatiner.top + paddings.top + margins.top,
        width: paddings.right,
        height: chart.height,
    }, 0, { color: lightBlueSemiTransparent });
    (0, debug_1.renderDebugRect)(ctx, {
        x: chart.left,
        y: conatiner.top + margins.top,
        width: chart.width,
        height: paddings.top,
    }, 0, { color: lightBlueSemiTransparent });
    (0, debug_1.renderDebugRect)(ctx, {
        x: chart.left,
        y: conatiner.top + chart.height + margins.top + paddings.top,
        width: chart.width,
        height: paddings.bottom,
    }, 0, { color: lightBlueSemiTransparent });
};
const renderHeatmapDebugElements = ({ ctx, container, chart, margins, paddings, }) => {
    renderDebugMargins(ctx, container, margins);
    renderDebugPaddings(ctx, container, chart, margins, paddings);
    (0, debug_1.renderDebugRect)(ctx, { x: chart.left, y: chart.top, width: chart.width, height: chart.height }, 0, { color: colors_1.Colors.Transparent.rgba }, { color: colors_1.Colors.Red.rgba, width: 4, dash: [4, 4] });
};
exports.renderHeatmapDebugElements = renderHeatmapDebugElements;
//# sourceMappingURL=debug.js.map