"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AnomaliesHostTable = void 0;
var _react = _interopRequireWildcard(require("react"));
var _reactRedux = require("react-redux");
var _eui = require("@elastic/eui");
var _use_anomalies_table_data = require("../anomaly/use_anomalies_table_data");
var _header_section = require("../../header_section");
var _has_ml_user_permissions = require("../../../../../common/machine_learning/has_ml_user_permissions");
var i18n = _interopRequireWildcard(require("./translations"));
var _get_anomalies_host_table_columns = require("./get_anomalies_host_table_columns");
var _convert_anomalies_to_hosts = require("./convert_anomalies_to_hosts");
var _loader = require("../../loader");
var _use_ml_capabilities = require("../hooks/use_ml_capabilities");
var _basic_table = require("./basic_table");
var _get_criteria_from_host_type = require("../criteria/get_criteria_from_host_type");
var _panel = require("../../panel");
var _query_toggle = require("../../../containers/query_toggle");
var _use_installed_security_jobs = require("../hooks/use_installed_security_jobs");
var _use_selector = require("../../../hooks/use_selector");
var _job_id_filter = require("./job_id_filter");
var _select_interval = require("./select_interval");
var _store = require("../../../../explore/hosts/store");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/ml/tables/anomalies_host_table.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const sorting = {
  sort: {
    field: 'anomaly.severity',
    direction: 'desc'
  }
};
const AnomaliesHostTableComponent = ({
  startDate,
  endDate,
  hostName,
  skip,
  type
}) => {
  const dispatch = (0, _reactRedux.useDispatch)();
  const capabilities = (0, _use_ml_capabilities.useMlCapabilities)();
  const {
    toggleStatus,
    setToggleStatus
  } = (0, _query_toggle.useQueryToggle)(`AnomaliesHostTable`);
  const [querySkip, setQuerySkip] = (0, _react.useState)(skip || !toggleStatus);
  (0, _react.useEffect)(() => {
    setQuerySkip(skip || !toggleStatus);
  }, [skip, toggleStatus]);
  const toggleQuery = (0, _react.useCallback)(status => {
    setToggleStatus(status);
    // toggle on = skipQuery false
    setQuerySkip(!status);
  }, [setQuerySkip, setToggleStatus]);
  const {
    jobNameById,
    loading: loadingJobs
  } = (0, _use_installed_security_jobs.useInstalledSecurityJobNameById)();
  const jobIds = (0, _react.useMemo)(() => Object.keys(jobNameById), [jobNameById]);
  const getAnomaliesHostsTableFilterQuerySelector = (0, _react.useMemo)(() => _store.hostsSelectors.hostsAnomaliesJobIdFilterSelector(), []);
  const selectedJobIds = (0, _use_selector.useDeepEqualSelector)(state => getAnomaliesHostsTableFilterQuerySelector(state, type));
  const onSelectJobId = (0, _react.useCallback)(newSelection => {
    dispatch(_store.hostsActions.updateHostsAnomaliesJobIdFilter({
      jobIds: newSelection,
      hostsType: type
    }));
  }, [dispatch, type]);
  const getAnomaliesHostTableIntervalQuerySelector = (0, _react.useMemo)(() => _store.hostsSelectors.hostsAnomaliesIntervalSelector(), []);
  const selectedInterval = (0, _use_selector.useDeepEqualSelector)(state => getAnomaliesHostTableIntervalQuerySelector(state, type));
  const onSelectInterval = (0, _react.useCallback)(newInterval => {
    dispatch(_store.hostsActions.updateHostsAnomaliesInterval({
      interval: newInterval,
      hostsType: type
    }));
  }, [dispatch, type]);
  const [loadingTable, tableData] = (0, _use_anomalies_table_data.useAnomaliesTableData)({
    startDate,
    endDate,
    skip: querySkip,
    criteriaFields: (0, _get_criteria_from_host_type.getCriteriaFromHostType)(type, hostName),
    filterQuery: {
      exists: {
        field: 'host.name'
      }
    },
    jobIds: selectedJobIds.length > 0 ? selectedJobIds : jobIds,
    aggregationInterval: selectedInterval
  });
  const hosts = (0, _convert_anomalies_to_hosts.convertAnomaliesToHosts)(tableData, jobNameById, hostName);
  const columns = (0, _get_anomalies_host_table_columns.getAnomaliesHostTableColumnsCurated)(type, startDate, endDate);
  const pagination = {
    initialPageIndex: 0,
    initialPageSize: 10,
    totalItemCount: hosts.length,
    pageSizeOptions: [5, 10, 20, 50],
    showPerPageOptions: true
  };
  if (!(0, _has_ml_user_permissions.hasMlUserPermissions)(capabilities)) {
    return null;
  } else {
    return /*#__PURE__*/_react.default.createElement(_panel.Panel, {
      loading: loadingTable || loadingJobs,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 133,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_header_section.HeaderSection, {
      subtitle: `${i18n.SHOWING}: ${pagination.totalItemCount.toLocaleString()} ${i18n.UNIT(pagination.totalItemCount)}`,
      title: i18n.ANOMALIES,
      toggleQuery: toggleQuery,
      toggleStatus: toggleStatus,
      tooltip: i18n.TOOLTIP,
      isInspectDisabled: skip,
      headerFilters: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 144,
          columnNumber: 13
        }
      }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 145,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_select_interval.SelectInterval, {
        interval: selectedInterval,
        onChange: onSelectInterval,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 146,
          columnNumber: 17
        }
      })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
        grow: false,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 148,
          columnNumber: 15
        }
      }, /*#__PURE__*/_react.default.createElement(_job_id_filter.JobIdFilter, {
        title: i18n.JOB_ID,
        onSelect: onSelectJobId,
        selectedJobIds: selectedJobIds,
        jobIds: jobIds,
        jobNameById: jobNameById,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 149,
          columnNumber: 17
        }
      }))),
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 134,
        columnNumber: 9
      }
    }), toggleStatus && /*#__PURE__*/_react.default.createElement(_basic_table.BasicTable, {
      "data-test-subj": "host-anomalies-table"
      // @ts-expect-error the Columns<T, U> type is not as specific as EUI's...
      ,
      columns: columns,
      items: hosts,
      pagination: pagination,
      sorting: sorting,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 161,
        columnNumber: 11
      }
    }), (loadingTable || loadingJobs) && /*#__PURE__*/_react.default.createElement(_loader.Loader, {
      "data-test-subj": "anomalies-host-table-loading-panel",
      overlay: true,
      size: "xl",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 172,
        columnNumber: 11
      }
    }));
  }
};
const AnomaliesHostTable = exports.AnomaliesHostTable = /*#__PURE__*/_react.default.memo(AnomaliesHostTableComponent);