"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.scoreIntervalToDateTime = void 0;
var _moment = _interopRequireDefault(require("moment"));
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const scoreIntervalToDateTime = (score, interval) => {
  if (interval === 'second' || interval === 'minute' || interval === 'hour') {
    return {
      from: (0, _moment.default)(score.time).subtract(1, 'hour').toISOString(),
      to: (0, _moment.default)(score.time).add(1, 'hour').toISOString()
    };
  } else {
    // default should be a day
    return {
      from: (0, _moment.default)(score.time).subtract(1, 'day').toISOString(),
      to: (0, _moment.default)(score.time).add(1, 'day').toISOString()
    };
  }
};
exports.scoreIntervalToDateTime = scoreIntervalToDateTime;