"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.default = exports.EmptyPromptComponent = void 0;
var _react = _interopRequireWildcard(require("react"));
var _eui = require("@elastic/eui");
var _react2 = require("@emotion/react");
var _constants = require("../../../onboarding/constants");
var _common = require("../../../../common");
var i18n = _interopRequireWildcard(require("./translations"));
var _endpoint = _interopRequireDefault(require("./images/endpoint1.svg"));
var _cloud = _interopRequireDefault(require("./images/cloud1.svg"));
var _siem = _interopRequireDefault(require("./images/siem1.svg"));
var _kibana = require("../../lib/kibana");
var _constants2 = require("../../constants");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/security/plugins/security_solution/public/common/components/empty_prompt/empty_prompt.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const imgUrls = {
  cloud: _cloud.default,
  siem: _siem.default,
  endpoint: _endpoint.default
};
const useEmptyPromptStyles = () => {
  const {
    euiTheme
  } = (0, _eui.useEuiTheme)();
  const headerCardStyles = (0, _react2.css)`
    span.euiTitle {
      font-size: ${euiTheme.base * 2.25}px;
      line-height: 100%;
    }
  `;
  const pageHeaderStyles = (0, _react2.css)`
    h1 {
      font-size: ${euiTheme.base * 1.125}px;
    }
  `;
  const flexItemStyles = (0, _react2.css)`
    background: ${euiTheme.colors.backgroundBaseSubdued};
    padding: ${euiTheme.base * 1.25}px;
  `;
  const cardStyles = (0, _react2.css)`
    img {
      margin-top: ${euiTheme.base * 1.25}px;
      max-width: ${euiTheme.components.forms.maxWidth};
    }
  `;
  const footerStyles = (0, _react2.css)`
    span.euiTitle {
      font-size: ${euiTheme.base * 2.25}px;
      line-height: 100%;
    }
    max-width: 600px;
    display: block;
    margin: ${euiTheme.base * 1.25}px auto 0;
  `;
  return (0, _react.useMemo)(() => ({
    headerCardStyles,
    pageHeaderStyles,
    flexItemStyles,
    cardStyles,
    footerStyles
  }), [cardStyles, flexItemStyles, footerStyles, headerCardStyles, pageHeaderStyles]);
};
const EmptyPromptComponent = exports.EmptyPromptComponent = /*#__PURE__*/(0, _react.memo)(({
  onSkip
}) => {
  const {
    headerCardStyles,
    pageHeaderStyles,
    flexItemStyles,
    cardStyles,
    footerStyles
  } = useEmptyPromptStyles();
  const {
    navigateTo
  } = (0, _kibana.useNavigateTo)();
  const navigateToAddIntegrations = (0, _react.useCallback)(() => {
    navigateTo({
      deepLinkId: _common.SecurityPageName.landing,
      path: `#${_constants.OnboardingCardId.integrations}`
    });
  }, [navigateTo]);
  const onClick = (0, _react.useCallback)(() => {
    navigateToAddIntegrations();
  }, [navigateToAddIntegrations]);
  return /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    "data-test-subj": "siem-landing-page",
    direction: "column",
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    grow: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 97,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "l",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 98,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 99,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageHeader, {
    pageTitle: i18n.SIEM_HEADER,
    iconType: "logoSecurity",
    css: pageHeaderStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 13
    }
  }), /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    display: "plain",
    description: i18n.SIEM_DESCRIPTION,
    textAlign: "left",
    title: i18n.SIEM_TITLE,
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "add-integrations-header",
      onClick: onClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 111,
        columnNumber: 17
      }
    }, i18n.SIEM_CTA),
    css: headerCardStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 105,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 118,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement("iframe", {
    allowFullScreen: true,
    className: "vidyard_iframe",
    frameBorder: "0",
    height: "100%",
    referrerPolicy: "no-referrer",
    sandbox: "allow-scripts allow-same-origin",
    scrolling: "no",
    src: _constants2.ONBOARDING_VIDEO_SOURCE,
    title: i18n.SIEM_HEADER,
    width: "100%",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 119,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    css: flexItemStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 134,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "m",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 135,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 136,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    hasBorder: true,
    description: i18n.SIEM_CARD_DESCRIPTION,
    image: imgUrls.siem,
    textAlign: "center",
    title: i18n.SIEM_CARD_TITLE,
    css: cardStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 137,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 146,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    hasBorder: true,
    description: i18n.ENDPOINT_DESCRIPTION,
    image: imgUrls.endpoint,
    textAlign: "center",
    title: i18n.ENDPOINT_TITLE,
    css: cardStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 147,
      columnNumber: 13
    }
  })), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 156,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    hasBorder: true,
    description: i18n.CLOUD_CARD_DESCRIPTION,
    image: imgUrls.cloud,
    textAlign: "center",
    title: i18n.CLOUD_CARD_TITLE,
    css: cardStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 157,
      columnNumber: 13
    }
  })))), /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 168,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiCard, {
    display: "plain",
    description: i18n.UNIFY_DESCRIPTION,
    paddingSize: "l",
    textAlign: "center",
    title: i18n.UNIFY_TITLE,
    footer: /*#__PURE__*/_react.default.createElement(_eui.EuiFlexGroup, {
      gutterSize: "s",
      justifyContent: "center",
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 176,
        columnNumber: 13
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 177,
        columnNumber: 15
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButton, {
      "data-test-subj": "add-integrations-footer",
      onClick: onClick,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 178,
        columnNumber: 17
      }
    }, i18n.SIEM_CTA)), onSkip && /*#__PURE__*/_react.default.createElement(_eui.EuiFlexItem, {
      grow: false,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 183,
        columnNumber: 17
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      "data-test-subj": "skip-integrations-footer",
      onClick: onSkip,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 184,
        columnNumber: 19
      }
    }, i18n.SIEM_CONTINUE))),
    css: footerStyles,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 169,
      columnNumber: 9
    }
  })));
});
EmptyPromptComponent.displayName = 'EmptyPromptComponent';

// eslint-disable-next-line import/no-default-export
var _default = exports.default = EmptyPromptComponent;