"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.TimestampOverrideObject = exports.TimelineTemplateReference = exports.SavedKqlQuery = exports.RuleNameOverrideObject = exports.RuleKqlQuery = exports.RuleEsqlQuery = exports.RuleEqlQuery = exports.RuleDataSource = exports.KqlQueryType = exports.InlineKqlQuery = exports.DataSourceType = exports.DataSourceIndexPatterns = exports.DataSourceDataView = exports.BuildingBlockObject = void 0;
var _zod = require("@kbn/zod");
var _rule_schema = require("../../../../model/rule_schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
// -------------------------------------------------------------------------------------------------
// Rule data source
let DataSourceType = exports.DataSourceType = /*#__PURE__*/function (DataSourceType) {
  DataSourceType["index_patterns"] = "index_patterns";
  DataSourceType["data_view"] = "data_view";
  return DataSourceType;
}({});
const DataSourceIndexPatterns = exports.DataSourceIndexPatterns = _zod.z.object({
  type: _zod.z.literal(DataSourceType.index_patterns),
  index_patterns: _rule_schema.IndexPatternArray
});
const DataSourceDataView = exports.DataSourceDataView = _zod.z.object({
  type: _zod.z.literal(DataSourceType.data_view),
  data_view_id: _rule_schema.DataViewId
});
const RuleDataSource = exports.RuleDataSource = _zod.z.discriminatedUnion('type', [DataSourceIndexPatterns, DataSourceDataView]);

// -------------------------------------------------------------------------------------------------
// Rule data query
let KqlQueryType = exports.KqlQueryType = /*#__PURE__*/function (KqlQueryType) {
  KqlQueryType["inline_query"] = "inline_query";
  KqlQueryType["saved_query"] = "saved_query";
  return KqlQueryType;
}({});
const InlineKqlQuery = exports.InlineKqlQuery = _zod.z.object({
  type: _zod.z.literal(KqlQueryType.inline_query),
  query: _rule_schema.RuleQuery,
  language: _rule_schema.KqlQueryLanguage,
  filters: _rule_schema.RuleFilterArray
});
const SavedKqlQuery = exports.SavedKqlQuery = _zod.z.object({
  type: _zod.z.literal(KqlQueryType.saved_query),
  saved_query_id: _rule_schema.SavedQueryId
});
const RuleKqlQuery = exports.RuleKqlQuery = _zod.z.discriminatedUnion('type', [InlineKqlQuery, SavedKqlQuery]);
const RuleEqlQuery = exports.RuleEqlQuery = _zod.z.object({
  query: _rule_schema.RuleQuery,
  language: _zod.z.literal('eql'),
  filters: _rule_schema.RuleFilterArray,
  event_category_override: _rule_schema.EventCategoryOverride.optional(),
  timestamp_field: _rule_schema.TimestampField.optional(),
  tiebreaker_field: _rule_schema.TiebreakerField.optional()
});
const RuleEsqlQuery = exports.RuleEsqlQuery = _zod.z.object({
  query: _rule_schema.RuleQuery,
  language: _zod.z.literal('esql')
});

// -------------------------------------------------------------------------------------------------
// Rule name override

const RuleNameOverrideObject = exports.RuleNameOverrideObject = _zod.z.object({
  field_name: _rule_schema.RuleNameOverride
});

// -------------------------------------------------------------------------------------------------
// Timestamp override

const TimestampOverrideObject = exports.TimestampOverrideObject = _zod.z.object({
  field_name: _rule_schema.TimestampOverride,
  fallback_disabled: _rule_schema.TimestampOverrideFallbackDisabled
});

// -------------------------------------------------------------------------------------------------
// Reference to a timeline template

const TimelineTemplateReference = exports.TimelineTemplateReference = _zod.z.object({
  timeline_id: _rule_schema.TimelineTemplateId,
  timeline_title: _rule_schema.TimelineTemplateTitle
});

// -------------------------------------------------------------------------------------------------
// Building block

const BuildingBlockObject = exports.BuildingBlockObject = _zod.z.object({
  type: _rule_schema.BuildingBlockType
});