"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.createDashboardsNavigationTree = void 0;
var _constants = require("../constants");
var _links = require("../links");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const createDashboardsNavigationTree = ({
  sideNavVersion
} = {
  sideNavVersion: 'v1'
}) => ({
  id: _constants.SecurityPageName.dashboards,
  iconV2: 'dashboardApp',
  link: (0, _links.securityLink)(_constants.SecurityPageName.dashboards),
  renderAs: 'item',
  sideNavVersion,
  children: [{
    id: _constants.SecurityPageName.overview,
    link: (0, _links.securityLink)(_constants.SecurityPageName.overview)
  }, {
    id: _constants.SecurityPageName.detectionAndResponse,
    link: (0, _links.securityLink)(_constants.SecurityPageName.detectionAndResponse)
  }, {
    id: _constants.SecurityPageName.cloudSecurityPostureDashboard,
    link: (0, _links.securityLink)(_constants.SecurityPageName.cloudSecurityPostureDashboard)
  }, {
    id: _constants.SecurityPageName.cloudSecurityPostureVulnerabilityDashboard,
    link: (0, _links.securityLink)(_constants.SecurityPageName.cloudSecurityPostureVulnerabilityDashboard)
  }, {
    id: _constants.SecurityPageName.entityAnalytics,
    link: (0, _links.securityLink)(_constants.SecurityPageName.entityAnalytics)
  }, {
    id: _constants.SecurityPageName.dataQuality,
    link: (0, _links.securityLink)(_constants.SecurityPageName.dataQuality)
  }]
});
exports.createDashboardsNavigationTree = createDashboardsNavigationTree;