"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getAttackDiscoveryFeature = void 0;
var _kibana_features = require("./kibana_features");
var _kibana_sub_features = require("./kibana_sub_features");
var _product_feature_config = require("./product_feature_config");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getAttackDiscoveryFeature = experimentalFeatures => ({
  baseKibanaFeature: (0, _kibana_features.getAttackDiscoveryBaseKibanaFeature)(),
  baseKibanaSubFeatureIds: (0, _kibana_sub_features.getAttackDiscoveryBaseKibanaSubFeatureIds)(),
  subFeaturesMap: (0, _kibana_sub_features.getAttackDiscoverySubFeaturesMap)(experimentalFeatures),
  productFeatureConfig: _product_feature_config.attackDiscoveryProductFeaturesConfig
});
exports.getAttackDiscoveryFeature = getAttackDiscoveryFeature;