"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AccessAgreementPage = AccessAgreementPage;
exports.renderAccessAgreementPage = renderAccessAgreementPage;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _eui = require("@elastic/eui");
var _react = require("@emotion/react");
var _react2 = _interopRequireWildcard(require("react"));
var _reactDom = _interopRequireDefault(require("react-dom"));
var _reactMarkdown = _interopRequireDefault(require("react-markdown"));
var _i18n = require("@kbn/i18n");
var _i18nReact = require("@kbn/i18n-react");
var _std = require("@kbn/std");
var _components = require("../components");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/security/public/authentication/access_agreement/access_agreement_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function AccessAgreementPage({
  http,
  fatalErrors,
  notifications
}) {
  const [isLoading, setIsLoading] = (0, _react2.useState)(false);
  const [accessAgreement, setAccessAgreement] = (0, _react2.useState)(null);
  (0, _react2.useEffect)(() => {
    http.get('/internal/security/access_agreement/state').then(response => setAccessAgreement(response.accessAgreement)).catch(err => fatalErrors.add(err));
  }, [http, fatalErrors]);
  const overFlowMixin = (0, _eui.useEuiOverflowScroll)('y', true);
  const onAcknowledge = (0, _react2.useCallback)(async e => {
    e.preventDefault();
    try {
      setIsLoading(true);
      await http.post('/internal/security/access_agreement/acknowledge');
      window.location.href = (0, _std.parseNextURL)(window.location.href, http.basePath.serverBasePath);
    } catch (err) {
      notifications.toasts.addError(err, {
        title: _i18n.i18n.translate('xpack.security.accessAgreement.acknowledgeErrorMessage', {
          defaultMessage: 'Could not acknowledge access agreement.'
        })
      });
      setIsLoading(false);
    }
  }, [http, notifications]);
  const content = accessAgreement ? /*#__PURE__*/_react2.default.createElement("form", {
    onSubmit: onAcknowledge,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 78,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    paddingSize: "none",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 79,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexGroup, {
    gutterSize: "none",
    direction: "column",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 80,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: (0, _react.css)`
              overflow-y: hidden;
            `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 81,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: ({
      euiTheme
    }) => (0, _react.css)`
                  max-height: '400px';
                  padding: ${euiTheme.size.base} ${euiTheme.size.l} 0;
                  ${overFlowMixin};
                `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 86,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiText, {
    textAlign: "left",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 95,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_reactMarkdown.default, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 96,
      columnNumber: 17
    }
  }, accessAgreement)))), /*#__PURE__*/_react2.default.createElement(_eui.EuiFlexItem, {
    css: ({
      euiTheme
    }) => (0, _react.css)`
                padding: ${euiTheme.size.base} ${euiTheme.size.l} ${euiTheme.size.l};
              `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 100,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react2.default.createElement("div", {
    css: (0, _react.css)`
                text-align: left;
              `,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 107,
      columnNumber: 13
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiButton, {
    fill: true,
    type: "submit",
    color: "primary",
    onClick: onAcknowledge,
    isDisabled: isLoading,
    isLoading: isLoading,
    "data-test-subj": "accessAgreementAcknowledge",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 112,
      columnNumber: 15
    }
  }, /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.security.accessAgreement.acknowledgeButtonText",
    defaultMessage: "Acknowledge and continue",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 121,
      columnNumber: 17
    }
  }))))))) : /*#__PURE__*/_react2.default.createElement(_eui.EuiPanel, {
    paddingSize: "l",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 132,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react2.default.createElement(_eui.EuiSkeletonText, {
    lines: 10,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 133,
      columnNumber: 7
    }
  }));
  return /*#__PURE__*/_react2.default.createElement(_components.AuthenticationStatePage, {
    cssStyles: (0, _react.css)`
        max-width: 600px;
      `,
    title: /*#__PURE__*/_react2.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.security.accessAgreement.title",
      defaultMessage: "Access Agreement",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 143,
        columnNumber: 9
      }
    }),
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 138,
      columnNumber: 5
    }
  }, content, /*#__PURE__*/_react2.default.createElement(_eui.EuiSpacer, {
    size: "xxl",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 150,
      columnNumber: 7
    }
  }));
}
function renderAccessAgreementPage(services, {
  element
}, props) {
  _reactDom.default.render(services.rendering.addContext(/*#__PURE__*/_react2.default.createElement(AccessAgreementPage, (0, _extends2.default)({}, props, {
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 160,
      columnNumber: 49
    }
  }))), element);
  return () => _reactDom.default.unmountComponentAtNode(element);
}