"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SearchIndicesPlugin = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _public = require("@kbn/core/public");
var _constants = require("@kbn/deeplinks-search/constants");
var _i18n = require("@kbn/i18n");
var _doc_links = require("../common/doc_links");
var _query_client = require("./services/query_client");
var _common = require("../common");
var _routes = require("./routes");
var _locators = require("./locators");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; } /*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
class SearchIndicesPlugin {
  constructor() {
    (0, _defineProperty2.default)(this, "pluginEnabled", false);
    (0, _defineProperty2.default)(this, "activeSolutionIdSubscription", void 0);
  }
  setup(core, plugins) {
    this.pluginEnabled = true;
    const queryClient = (0, _query_client.initQueryClient)(core.notifications.toasts);
    core.application.register({
      id: _common.INDICES_APP_ID,
      appRoute: _routes.INDICES_APP_BASE,
      deepLinks: [{
        id: _constants.SEARCH_INDICES_CREATE_INDEX,
        path: _routes.CREATE_INDEX_PATH,
        title: _i18n.i18n.translate('xpack.searchIndices.elasticsearchIndices.createIndexTitle', {
          defaultMessage: 'Create index'
        }),
        visibleIn: ['globalSearch']
      }],
      title: _i18n.i18n.translate('xpack.searchIndices.elasticsearchIndices.startAppTitle', {
        defaultMessage: 'Elasticsearch Indices'
      }),
      async mount({
        element,
        history
      }) {
        const {
          renderApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./application')));
        const {
          SearchIndicesRouter
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./components/indices_router')));
        const [coreStart, depsStart] = await core.getStartServices();
        const startDeps = {
          ...depsStart,
          history
        };
        return renderApp(SearchIndicesRouter, coreStart, startDeps, element, queryClient);
      },
      visibleIn: []
    });
    core.application.register({
      id: _common.SEARCH_INDEX_MANAGEMENT_APP_ID,
      appRoute: _routes.SEARCH_INDEX_MANAGEMENT_APP_BASE,
      category: _public.DEFAULT_APP_CATEGORIES.enterpriseSearch,
      title: _i18n.i18n.translate('xpack.searchIndices.elasticsearchIndices.indexManagementTitle', {
        defaultMessage: 'Index Management'
      }),
      async mount({
        element,
        history
      }) {
        const {
          renderIndexManagementApp
        } = await Promise.resolve().then(() => _interopRequireWildcard(require('./index_management_application')));
        return renderIndexManagementApp(element, {
          core,
          history,
          indexManagement: plugins.indexManagement
        });
      },
      order: 2,
      visibleIn: ['sideNav']
    });
    (0, _locators.registerLocators)(plugins.share);
    return {
      enabled: true
    };
  }
  start(core, deps) {
    const {
      indexManagement
    } = deps;
    _doc_links.docLinks.setDocLinks(core.docLinks.links);
    if (this.pluginEnabled) {
      this.activeSolutionIdSubscription = core.chrome.getActiveSolutionNavId$().subscribe(activeSolutionId => {
        if (activeSolutionId === 'es') {
          indexManagement === null || indexManagement === void 0 ? void 0 : indexManagement.extensionsService.setIndexDetailsPageRoute({
            renderRoute: (indexName, detailsTabId) => {
              const route = `/app/elasticsearch/indices/index_details/${indexName}`;
              if (detailsTabId && _routes.SearchIndexDetailsTabValues.includes(detailsTabId)) {
                return `${route}/${detailsTabId}`;
              }
              return route;
            }
          });
        }
      });
    }
    return {
      enabled: this.pluginEnabled
    };
  }
  stop() {
    if (this.activeSolutionIdSubscription) {
      this.activeSolutionIdSubscription.unsubscribe();
      this.activeSolutionIdSubscription = undefined;
    }
  }
}
exports.SearchIndicesPlugin = SearchIndicesPlugin;