"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.CreateIndexPage = void 0;
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _sharedUxPageKibanaTemplate = require("@kbn/shared-ux-page-kibana-template");
var _use_kibana = require("../../hooks/use_kibana");
var _use_indices_status = require("../../hooks/api/use_indices_status");
var _load_indices_status_error = require("../shared/load_indices_status_error");
var _create_index = require("./create_index");
var _use_page_chrome = require("../../hooks/use_page_chrome");
var _use_index_management_breadcrumbs = require("../../hooks/use_index_management_breadcrumbs");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/solutions/search/plugins/search_indices/public/components/create_index/create_index_page.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const CreateIndexLabel = _i18n.i18n.translate('xpack.searchIndices.createIndex.docTitle', {
  defaultMessage: 'Create Index'
});
const CreateIndexPage = () => {
  const {
    console: consolePlugin,
    history,
    searchNavigation
  } = (0, _use_kibana.useKibana)().services;
  const {
    data: indicesData,
    isInitialLoading,
    isError: hasIndicesStatusFetchError,
    error: indicesFetchError
  } = (0, _use_indices_status.useIndicesStatusQuery)();
  const embeddableConsole = (0, _react.useMemo)(() => consolePlugin !== null && consolePlugin !== void 0 && consolePlugin.EmbeddableConsole ? /*#__PURE__*/_react.default.createElement(consolePlugin.EmbeddableConsole, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 36,
      columnNumber: 47
    }
  }) : null, [consolePlugin]);
  const indexManagementBreadcrumbs = (0, _use_index_management_breadcrumbs.useIndexManagementBreadcrumbs)();
  (0, _use_page_chrome.usePageChrome)(CreateIndexLabel, [...indexManagementBreadcrumbs, {
    text: CreateIndexLabel
  }]);
  return /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate, {
    offset: 0,
    restrictWidth: false,
    "data-test-subj": "elasticsearchCreateIndexPage",
    grow: false,
    solutionNav: searchNavigation === null || searchNavigation === void 0 ? void 0 : searchNavigation.useClassicNavigation(history),
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 48,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_sharedUxPageKibanaTemplate.KibanaPageTemplate.Section, {
    alignment: "top",
    restrictWidth: false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 55,
      columnNumber: 7
    }
  }, isInitialLoading && /*#__PURE__*/_react.default.createElement(_eui.EuiLoadingLogo, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 56,
      columnNumber: 30
    }
  }), hasIndicesStatusFetchError && /*#__PURE__*/_react.default.createElement(_load_indices_status_error.LoadIndicesStatusError, {
    error: indicesFetchError,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 57,
      columnNumber: 40
    }
  }), !isInitialLoading && !hasIndicesStatusFetchError && /*#__PURE__*/_react.default.createElement(_create_index.CreateIndex, {
    indicesData: indicesData,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 59,
      columnNumber: 11
    }
  })), embeddableConsole);
};
exports.CreateIndexPage = CreateIndexPage;