"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getDiscoverSession = void 0;
var _common = require("@kbn/data-plugin/common");
var _get_saved_searches = require("./get_saved_searches");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const getDiscoverSession = async (discoverSessionId, deps) => {
  const so = await (0, _get_saved_searches.getSearchSavedObject)(discoverSessionId, deps);
  const discoverSession = {
    id: so.item.id,
    title: so.item.attributes.title,
    description: so.item.attributes.description,
    // TODO: so.item.attributes.tabs shouldn't be nullable soon
    tabs: so.item.attributes.tabs.map(tab => {
      var _tab$attributes$kiban, _tab$attributes$kiban2;
      return {
        id: tab.id,
        label: tab.label,
        sort: tab.attributes.sort,
        columns: tab.attributes.columns,
        grid: tab.attributes.grid,
        hideChart: tab.attributes.hideChart,
        isTextBasedQuery: tab.attributes.isTextBasedQuery,
        usesAdHocDataView: tab.attributes.usesAdHocDataView,
        serializedSearchSource: (0, _common.injectReferences)((0, _common.parseSearchSourceJSON)((_tab$attributes$kiban = (_tab$attributes$kiban2 = tab.attributes.kibanaSavedObjectMeta) === null || _tab$attributes$kiban2 === void 0 ? void 0 : _tab$attributes$kiban2.searchSourceJSON) !== null && _tab$attributes$kiban !== void 0 ? _tab$attributes$kiban : '{}'), so.item.references),
        viewMode: tab.attributes.viewMode,
        hideAggregatedPreview: tab.attributes.hideAggregatedPreview,
        rowHeight: tab.attributes.rowHeight,
        headerRowHeight: tab.attributes.headerRowHeight,
        timeRestore: tab.attributes.timeRestore,
        timeRange: tab.attributes.timeRange,
        refreshInterval: tab.attributes.refreshInterval,
        rowsPerPage: tab.attributes.rowsPerPage,
        sampleSize: tab.attributes.sampleSize,
        breakdownField: tab.attributes.breakdownField,
        density: tab.attributes.density,
        visContext: tab.attributes.visContext,
        controlGroupJson: tab.attributes.controlGroupJson
      };
    }),
    managed: Boolean(so.item.managed),
    tags: deps.savedObjectsTagging ? deps.savedObjectsTagging.ui.getTagIdsFromReferences(so.item.references) : undefined,
    references: so.item.references,
    sharingSavedObjectProps: so.meta
  };
  return discoverSession;
};
exports.getDiscoverSession = getDiscoverSession;