"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.SavedObjectsManagementColumnService = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _columns = require("./columns");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

class SavedObjectsManagementColumnService {
  constructor() {
    (0, _defineProperty2.default)(this, "columns", new Map());
  }
  setup() {
    return {
      register: column => this.register(column)
    };
  }
  start(spacesApi) {
    if (spacesApi && !spacesApi.hasOnlyDefaultSpace) {
      this.register(new _columns.ShareToSpaceSavedObjectsManagementColumn(spacesApi.ui));
    }
    return {
      getAll: () => [...this.columns.values()]
    };
  }
  register(column) {
    if (this.columns.has(column.id)) {
      throw new Error(`Saved Objects Management Column with id '${column.id}' already exists`);
    }
    this.columns.set(column.id, column);
  }
}
exports.SavedObjectsManagementColumnService = SavedObjectsManagementColumnService;