"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.stripBadDefault = exports.processDiscontinued = exports.processDeprecated = exports.isAnyType = exports.deleteField = void 0;
var _configSchema = require("@kbn/config-schema");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const stripBadDefault = schema => {
  var _schema$default;
  if (((_schema$default = schema.default) === null || _schema$default === void 0 ? void 0 : _schema$default.special) === 'deep') {
    if (Object.keys(schema.default).length === 1) {
      delete schema.default;
    } else {
      delete schema.default.special;
    }
  }
  if (typeof schema.default === 'function') {
    const defaultValue = schema.default();
    if (defaultValue === undefined) {
      delete schema.default;
    } else {
      schema.default = defaultValue;
    }
  }
};
exports.stripBadDefault = stripBadDefault;
const processDeprecated = schema => {
  if (_configSchema.metaFields.META_FIELD_X_OAS_DEPRECATED in schema) {
    schema.deprecated = true;
    deleteField(schema, _configSchema.metaFields.META_FIELD_X_OAS_DEPRECATED);
  }
};
exports.processDeprecated = processDeprecated;
const processDiscontinued = schema => {
  if (_configSchema.metaFields.META_FIELD_X_OAS_DISCONTINUED in schema) {
    schema['x-discontinued'] = schema[_configSchema.metaFields.META_FIELD_X_OAS_DISCONTINUED];
    deleteField(schema, _configSchema.metaFields.META_FIELD_X_OAS_DISCONTINUED);
  }
};

/** Just for type convenience */
exports.processDiscontinued = processDiscontinued;
const deleteField = (schema, field) => {
  delete schema[field];
};
exports.deleteField = deleteField;
const isAnyType = schema => {
  return _configSchema.metaFields.META_FIELD_X_OAS_ANY in schema;
};
exports.isAnyType = isAnyType;