"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.validateHistogramInterval = validateHistogramInterval;
var _react = _interopRequireDefault(require("react"));
var _i18nReact = require("@kbn/i18n-react");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/rollup/public/crud_app/sections/job_create/steps_config/validate_histogram_interval.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function validateHistogramInterval(histogram, histogramInterval) {
  // If there are no selected histogram fields then we don't need to validate the interval.
  if (!histogram.length) {
    return undefined;
  }
  if (histogramInterval <= 0) {
    return [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.errors.histogramIntervalZero",
      defaultMessage: "Interval must be greater than zero.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 19,
        columnNumber: 7
      }
    })];
  }
  if (Math.round(histogramInterval) !== Number(histogramInterval)) {
    return [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.errors.histogramIntervalWholeNumber",
      defaultMessage: "Interval must be a whole number.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 28,
        columnNumber: 7
      }
    })];
  }
  if (!histogramInterval) {
    return [/*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
      id: "xpack.rollupJobs.create.errors.histogramIntervalMissing",
      defaultMessage: "An interval is required to roll up these histogram fields.",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 37,
        columnNumber: 7
      }
    })];
  }
  return undefined;
}