"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.metricThresholdRuleParamsSchema = void 0;
var _configSchema = require("@kbn/config-schema");
var _alertingComparators = require("@kbn/alerting-comparators");
var _utils = require("../common/utils");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

const METRIC_EXPLORER_AGGREGATIONS = ['avg', 'max', 'min', 'cardinality', 'rate', 'count', 'sum', 'p95', 'p99', 'custom'];
const comparator = Object.values({
  ..._alertingComparators.COMPARATORS,
  ..._utils.LEGACY_COMPARATORS
});
const baseCriterion = {
  threshold: _configSchema.schema.arrayOf(_configSchema.schema.number(), {
    meta: {
      description: 'The threshold value that is used with the `comparator`. If the `comparator` is `between`, you must specify the boundary values.'
    }
  }),
  comparator: (0, _utils.oneOfLiterals)(comparator),
  timeUnit: _configSchema.schema.string({
    meta: {
      description: 'The type of units for the time window: seconds, minutes, hours, or days.'
    }
  }),
  timeSize: _configSchema.schema.number({
    meta: {
      description: 'The size of the time window (in `timeUnit` units), which determines how far back to search for documents. Generally it should be a value higher than the rule check interval to avoid gaps in detection.'
    }
  }),
  warningThreshold: _configSchema.schema.maybe(_configSchema.schema.arrayOf(_configSchema.schema.number({
    meta: {
      description: 'The threshold value that is used with the `warningComparator`. If the `warningComparator` is `between`, you must specify the boundary values.'
    }
  }))),
  warningComparator: _configSchema.schema.maybe((0, _utils.oneOfLiterals)(comparator))
};
const nonCountCriterion = _configSchema.schema.object({
  ...baseCriterion,
  metric: _configSchema.schema.string(),
  aggType: (0, _utils.oneOfLiterals)(METRIC_EXPLORER_AGGREGATIONS),
  customMetrics: _configSchema.schema.never(),
  equation: _configSchema.schema.never(),
  label: _configSchema.schema.never()
});
const countCriterion = _configSchema.schema.object({
  ...baseCriterion,
  aggType: _configSchema.schema.literal('count'),
  metric: _configSchema.schema.never(),
  customMetrics: _configSchema.schema.never(),
  equation: _configSchema.schema.never(),
  label: _configSchema.schema.never()
});
const customCriterion = _configSchema.schema.object({
  ...baseCriterion,
  aggType: _configSchema.schema.literal('custom'),
  metric: _configSchema.schema.never(),
  customMetrics: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([_configSchema.schema.object({
    name: _configSchema.schema.string(),
    aggType: (0, _utils.oneOfLiterals)(['avg', 'sum', 'max', 'min', 'cardinality']),
    field: _configSchema.schema.string(),
    filter: _configSchema.schema.never()
  }), _configSchema.schema.object({
    name: _configSchema.schema.string(),
    aggType: _configSchema.schema.literal('count'),
    filter: _configSchema.schema.maybe(_configSchema.schema.string()),
    field: _configSchema.schema.never()
  })])),
  equation: _configSchema.schema.maybe(_configSchema.schema.string()),
  label: _configSchema.schema.maybe(_configSchema.schema.string())
});
const metricThresholdRuleParamsSchema = exports.metricThresholdRuleParamsSchema = _configSchema.schema.object({
  criteria: _configSchema.schema.arrayOf(_configSchema.schema.oneOf([countCriterion, nonCountCriterion, customCriterion])),
  groupBy: _configSchema.schema.maybe(_configSchema.schema.oneOf([_configSchema.schema.string(), _configSchema.schema.arrayOf(_configSchema.schema.string())], {
    meta: {
      description: 'Create an alert for every unique value of the specified fields. For example, you can create a rule per host or every mount point of each host. IMPORTANT: If you include the same field in both the `filterQuery` and `groupBy`, you might receive fewer results than you expect. For example, if you filter by `cloud.region: us-east`, grouping by `cloud.region` will have no effect because the filter query can match only one region.'
    }
  })),
  filterQuery: _configSchema.schema.maybe(_configSchema.schema.string({
    validate: _utils.validateIsStringElasticsearchJSONFilter,
    meta: {
      description: 'A query that limits the scope of the rule. The rule evaluates only metric data that matches the query.'
    }
  })),
  sourceId: _configSchema.schema.string(),
  alertOnNoData: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'If true, an alert occurs if the metrics do not report any data over the expected period or if the query fails.'
    }
  })),
  alertOnGroupDisappear: _configSchema.schema.maybe(_configSchema.schema.boolean({
    meta: {
      description: 'If true, an alert occurs if a group that previously reported metrics does not report them again over the expected time period. This check is not recommended for dynamically scaling infrastructures that might rapidly start and stop nodes automatically.'
    }
  }))
}, {
  unknowns: 'allow'
});