"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.registerScheduledReportsRoutesInternal = registerScheduledReportsRoutesInternal;
var _list = require("./list");
var _bulk_disable = require("./bulk_disable");
var _post = require("./post");
var _bulk_delete = require("./bulk_delete");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function registerScheduledReportsRoutesInternal(reporting, logger) {
  const setupDeps = reporting.getPluginSetupDeps();
  const {
    router
  } = setupDeps;
  (0, _list.registerInternalListRoute)({
    logger,
    router,
    reporting
  });
  (0, _bulk_disable.registerInternalBulkDisableRoute)({
    logger,
    router,
    reporting
  });
  (0, _post.registerInternalPostScheduleRoute)({
    logger,
    router,
    reporting
  });
  (0, _bulk_delete.registerInternalBulkDeleteRoute)({
    logger,
    router,
    reporting
  });
}