"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useIsOsqueryAvailable = void 0;
var _react = require("react");
var _lodash = require("lodash");
var _agent_policies = require("../agent_policies");
var _common = require("../../common");
var _use_agent_details = require("../agents/use_agent_details");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useIsOsqueryAvailable = agentId => {
  const {
    data: agentData,
    isFetched: agentFetched,
    isLoading
  } = (0, _use_agent_details.useAgentDetails)({
    agentId,
    silent: true,
    skip: !agentId
  });
  const {
    data: agentPolicyData,
    isFetched: policyFetched,
    isError: policyError,
    isLoading: policyLoading
  } = (0, _agent_policies.useAgentPolicy)({
    policyId: agentData === null || agentData === void 0 ? void 0 : agentData.policy_id,
    skip: !agentData,
    silent: true
  });
  const osqueryAvailable = (0, _react.useMemo)(() => {
    if (policyError) return false;
    const osqueryPackageInstalled = (0, _lodash.find)(agentPolicyData === null || agentPolicyData === void 0 ? void 0 : agentPolicyData.package_policies, ['package.name', _common.OSQUERY_INTEGRATION_NAME]);
    return !(0, _lodash.isString)(osqueryPackageInstalled) ? !!(osqueryPackageInstalled !== null && osqueryPackageInstalled !== void 0 && osqueryPackageInstalled.enabled) : false;
  }, [agentPolicyData === null || agentPolicyData === void 0 ? void 0 : agentPolicyData.package_policies, policyError]);
  return {
    osqueryAvailable,
    agentFetched,
    isLoading,
    policyFetched,
    policyLoading,
    agentData
  };
};
exports.useIsOsqueryAvailable = useIsOsqueryAvailable;