"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getActionResultsRequestQuerySchema = exports.getActionResultsRequestParamsSchema = void 0;
var t = _interopRequireWildcard(require("io-ts"));
var _ioTsUtils = require("@kbn/io-ts-utils");
var _search_strategy = require("../../search_strategy");
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const getActionResultsRequestQuerySchema = exports.getActionResultsRequestQuerySchema = t.type({
  startDate: t.union([t.string, t.undefined]),
  page: t.union([_ioTsUtils.toNumberRt, t.undefined]),
  pageSize: t.union([_ioTsUtils.toNumberRt, t.undefined]),
  sort: t.union([t.string, t.undefined]),
  sortOrder: t.union([t.literal(_search_strategy.Direction.asc), t.literal(_search_strategy.Direction.desc), t.undefined]),
  kuery: t.union([t.string, t.undefined]),
  /**
   * Optional comma-separated list of agent IDs to filter results.
   * For external API consumers only. Limited to 100 agents max.
   * Internal UI does not use this parameter - server fetches agents from action document.
   */
  agentIds: t.union([t.string, t.undefined])
});
const getActionResultsRequestParamsSchema = exports.getActionResultsRequestParamsSchema = t.type({
  actionId: t.string
});