"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.getFallbackKibanaUrl = getFallbackKibanaUrl;
exports.useKibanaUrl = void 0;
var _react = require("react");
var _use_onechat_service = require("./use_onechat_service");
var _use_kibana = require("./use_kibana");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const useKibanaUrl = () => {
  const {
    startDependencies: {
      cloud
    }
  } = (0, _use_onechat_service.useOnechatServices)();
  const {
    services: {
      http
    }
  } = (0, _use_kibana.useKibana)();
  const kibanaUrl = (0, _react.useMemo)(() => {
    var _ref, _http$basePath$public;
    return (_ref = (_http$basePath$public = http.basePath.publicBaseUrl) !== null && _http$basePath$public !== void 0 ? _http$basePath$public : cloud === null || cloud === void 0 ? void 0 : cloud.kibanaUrl) !== null && _ref !== void 0 ? _ref : getFallbackKibanaUrl(http);
  }, [cloud, http]);
  return {
    kibanaUrl
  };
};
exports.useKibanaUrl = useKibanaUrl;
function getFallbackKibanaUrl(http) {
  return `${window.location.origin}${http.basePath.get()}`;
}