"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.combineFieldsWithStats = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

const combineFieldsWithStats = ({
  fields,
  stats
}) => {
  return fields.map(field => {
    var _stats$fieldStats$fie;
    const fieldStats = (_stats$fieldStats$fie = stats.fieldStats[field.path]) !== null && _stats$fieldStats$fie !== void 0 ? _stats$fieldStats$fie : {
      filledDocCount: 0,
      emptyDocCount: stats.sampleCount,
      values: []
    };
    return {
      ...field,
      stats: fieldStats
    };
  });
};
exports.combineFieldsWithStats = combineFieldsWithStats;