"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ToolType = void 0;
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
/**
 * Possible types of tools
 */
let ToolType = exports.ToolType = /*#__PURE__*/function (ToolType) {
  ToolType["builtin"] = "builtin";
  ToolType["esql"] = "esql";
  ToolType["workflow"] = "workflow";
  ToolType["index_search"] = "index_search";
  return ToolType;
}({});
/**
 * Serializable representation of a tool, without its handler or schema.
 *
 * Use as a common base for browser-side and server-side tool types.
 */