"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.updateGlobalNavigation = updateGlobalNavigation;
var _public = require("@kbn/cases-plugin/public");
var _common = require("../../common");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function updateGlobalNavigation({
  capabilities,
  deepLinks,
  updater$,
  pricing
}) {
  var _capabilities$logs;
  const isCompleteOverviewEnabled = pricing.isFeatureAvailable('observability:complete_overview');
  const {
    apm,
    metrics,
    uptime,
    synthetics,
    slo
  } = capabilities.navLinks;
  /* logs is a special case.
   * It is not a nav link but still exists as a
   * Kibana feature privilege with attached rule types */
  const logs = (_capabilities$logs = capabilities.logs) === null || _capabilities$logs === void 0 ? void 0 : _capabilities$logs.show;
  const someVisible = Object.values({
    apm,
    logs,
    metrics,
    uptime,
    synthetics,
    slo
  }).some(visible => visible) || !isCompleteOverviewEnabled;
  const updatedDeepLinks = deepLinks.map(link => {
    switch (link.id) {
      case _public.CasesDeepLinkId.cases:
        if (capabilities[_common.casesFeatureId].read_cases) {
          return {
            ...link,
            visibleIn: ['sideNav', 'globalSearch']
          };
        }
        return null;
      case 'alerts':
        if (someVisible) {
          return {
            ...link,
            visibleIn: ['sideNav', 'globalSearch']
          };
        }
        return null;
      case 'rules':
        if (someVisible) {
          return {
            ...link,
            visibleIn: ['sideNav', 'globalSearch']
          };
        }
        return null;
      default:
        return link;
    }
  }).filter(link => link !== null);
  updater$.next(() => {
    const visibleIn = someVisible ? ['sideNav', 'home', 'kibanaOverview'] : [];
    if (isCompleteOverviewEnabled && someVisible) {
      visibleIn.push('globalSearch');
    }
    return {
      deepLinks: updatedDeepLinks,
      visibleIn
    };
  });
}