"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.ActionsMenu = ActionsMenu;
var _extends2 = _interopRequireDefault(require("@babel/runtime/helpers/extends"));
var _react = _interopRequireWildcard(require("react"));
var _i18n = require("@kbn/i18n");
var _eui = require("@elastic/eui");
var _connector_selector_base = require("../connector_selector/connector_selector_base");
var _use_kibana = require("../../hooks/use_kibana");
var _navigate_to_connectors = require("../../utils/navigate_to_connectors");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/observability_ai_assistant/public/components/insight/actions_menu.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
function ActionsMenu({
  connectors,
  onEditPrompt
}) {
  var _connectors$connector, _connectors$connector2;
  const {
    application
  } = (0, _use_kibana.useKibana)().services;
  const [isPopoverOpen, setPopover] = (0, _react.useState)(false);
  const onButtonClick = () => {
    setPopover(!isPopoverOpen);
  };
  const closePopover = () => {
    setPopover(false);
  };
  const panels = [{
    id: 0,
    title: 'Actions',
    items: [{
      name: /*#__PURE__*/_react.default.createElement("div", {
        className: "eui-textTruncate",
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 40,
          columnNumber: 13
        }
      }, _i18n.i18n.translate('xpack.observabilityAiAssistant.insight.actions.connector', {
        defaultMessage: 'Connector'
      }), ' ', /*#__PURE__*/_react.default.createElement("strong", {
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 44,
          columnNumber: 15
        }
      }, (_connectors$connector = connectors.connectors) === null || _connectors$connector === void 0 ? void 0 : (_connectors$connector2 = _connectors$connector.find(({
        id
      }) => id === connectors.selectedConnector)) === null || _connectors$connector2 === void 0 ? void 0 : _connectors$connector2.name)),
      icon: 'wrench',
      panel: 1
    }, {
      name: _i18n.i18n.translate('xpack.observabilityAiAssistant.insight.actions.editPrompt', {
        defaultMessage: 'Edit prompt'
      }),
      icon: 'documentEdit',
      onClick: () => {
        onEditPrompt();
        closePopover();
      }
    }]
  }, {
    id: 1,
    title: _i18n.i18n.translate('xpack.observabilityAiAssistant.insight.actions.connector', {
      defaultMessage: 'Connector'
    }),
    content: /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 70,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement(_connector_selector_base.ConnectorSelectorBase, (0, _extends2.default)({}, connectors, {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 71,
        columnNumber: 11
      }
    })), /*#__PURE__*/_react.default.createElement(_eui.EuiButtonEmpty, {
      flush: "left",
      size: "xs",
      onClick: () => (0, _navigate_to_connectors.navigateToConnectorsManagementApp)(application),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 72,
        columnNumber: 11
      }
    }, _i18n.i18n.translate('xpack.observabilityAiAssistant.insight.actions.connector.manageConnectors', {
      defaultMessage: 'Manage connectors'
    })))
  }];
  const button = /*#__PURE__*/_react.default.createElement(_eui.EuiButtonIcon, {
    "aria-label": _i18n.i18n.translate('xpack.observabilityAiAssistant.insight.openActions', {
      defaultMessage: 'Open insight actions'
    }),
    "data-test-subj": "observabilityAiAssistantInsightActionsButtonIcon",
    iconType: "boxesHorizontal",
    onClick: onButtonClick,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 90,
      columnNumber: 5
    }
  });
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPopover, {
    button: button,
    isOpen: isPopoverOpen,
    closePopover: closePopover,
    panelPaddingSize: "none",
    anchorPosition: "downLeft",
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 101,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiContextMenu, {
    initialPanelId: 0,
    panels: panels,
    __self: this,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 108,
      columnNumber: 7
    }
  }));
}