"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.Ccr = void 0;
var _react = _interopRequireWildcard(require("react"));
var _react2 = require("@emotion/react");
var _eui = require("@elastic/eui");
var _i18nReact = require("@kbn/i18n-react");
var _i18n = require("@kbn/i18n");
var _get_safe_for_external_link = require("../../../lib/get_safe_for_external_link");
var _status = require("../../../alerts/status");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/private/monitoring/public/components/elasticsearch/ccr/ccr.js";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
/**
 * We want the collapsed table (that shows the shard data) to be inline
 * with the columns from the main table so we need to remove the padding
 */
const ccrListingTableStyle = (0, _react2.css)`
  .euiTableRow-isExpandedRow > .euiTableRowCell > .euiTableCellContent {
    padding: 0;
  }
`;
function toSeconds(ms) {
  return Math.floor(ms / 1000) + 's';
}
const Ccr = props => {
  const [itemIdToExpandedRowMap, setItemIdToExpandedRowMap] = (0, _react.useState)({});
  const toggleShards = (index, shards) => {
    const itemIdToExpandedRowMapValues = {
      ...itemIdToExpandedRowMap
    };
    if (itemIdToExpandedRowMapValues[index]) {
      delete itemIdToExpandedRowMapValues[index];
    } else {
      let pagination = {
        initialPageSize: 5,
        pageSizeOptions: [5, 10, 20]
      };
      if (shards.length <= pagination.initialPageSize) {
        pagination = false;
      }
      itemIdToExpandedRowMapValues[index] = /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
        items: shards,
        columns: [{
          field: 'shardId',
          name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.shardsTable.shardColumnTitle', {
            defaultMessage: 'Shard'
          }),
          render: shardId => {
            return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
              href: (0, _get_safe_for_external_link.getSafeForExternalLink)(`#/elasticsearch/ccr/${index}/shard/${shardId}`),
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 73,
                columnNumber: 19
              }
            }, shardId);
          }
        }, {
          render: () => null
        }, {
          field: 'alerts',
          sortable: true,
          name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.shardsTable.alertsColumnTitle', {
            defaultMessage: 'Alerts'
          }),
          render: (_field, item) => {
            return /*#__PURE__*/_react.default.createElement(_status.AlertsStatus, {
              showBadge: true,
              alerts: props.alerts,
              stateFilter: state => state.meta.shardId === item.shardId,
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 95,
                columnNumber: 19
              }
            });
          }
        }, {
          field: 'syncLagOps',
          name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.shardsTable.syncLagOpsColumnTitle', {
            defaultMessage: 'Sync Lag (ops)'
          }),
          render: (syncLagOps, data) => /*#__PURE__*/_react.default.createElement("span", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 112,
              columnNumber: 17
            }
          }, syncLagOps, "\xA0\xA0", /*#__PURE__*/_react.default.createElement(_eui.EuiIconTip, {
            size: "m",
            type: "info",
            content: /*#__PURE__*/_react.default.createElement(_react.Fragment, {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 119,
                columnNumber: 23
              }
            }, /*#__PURE__*/_react.default.createElement("span", {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 120,
                columnNumber: 25
              }
            }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.monitoring.elasticsearch.ccr.shardsTable.syncLagOpsColumn.leaderLagTooltip",
              defaultMessage: "Leader lag: {syncLagOpsLeader}",
              values: {
                syncLagOpsLeader: data.syncLagOpsLeader
              },
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 121,
                columnNumber: 27
              }
            })), /*#__PURE__*/_react.default.createElement("br", {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 129,
                columnNumber: 25
              }
            }), /*#__PURE__*/_react.default.createElement("span", {
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 130,
                columnNumber: 25
              }
            }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
              id: "xpack.monitoring.elasticsearch.ccr.shardsTable.syncLagOpsColumn.followerLagTooltip",
              defaultMessage: "Follower lag: {syncLagOpsFollower}",
              values: {
                syncLagOpsFollower: data.syncLagOpsFollower
              },
              __self: void 0,
              __source: {
                fileName: _jsxFileName,
                lineNumber: 131,
                columnNumber: 27
              }
            }))),
            position: "right",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 115,
              columnNumber: 19
            }
          }))
        }, {
          field: 'syncLagTime',
          name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.shardsTable.lastFetchTimeColumnTitle', {
            defaultMessage: 'Last fetch time'
          }),
          render: syncLagTime => /*#__PURE__*/_react.default.createElement("span", {
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 154,
              columnNumber: 40
            }
          }, toSeconds(syncLagTime))
        }, {
          field: 'opsSynced',
          name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.shardsTable.opsSyncedColumnTitle', {
            defaultMessage: 'Ops synced'
          })
        }, {
          field: 'error',
          name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.shardsTable.errorColumnTitle', {
            defaultMessage: 'Error'
          }),
          render: error => /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
            color: "danger",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 173,
              columnNumber: 34
            }
          }, error)
        }],
        executeQueryOptions: {
          defaultFields: ['shardId']
        },
        sorting: true,
        pagination: pagination,
        __self: void 0,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 60,
          columnNumber: 9
        }
      });
    }
    setItemIdToExpandedRowMap(itemIdToExpandedRowMapValues);
  };
  const renderTable = () => {
    const {
      data,
      alerts
    } = props;
    const items = data;
    let pagination = {
      initialPageSize: 5,
      pageSizeOptions: [5, 10, 20]
    };
    if (items.length <= pagination.initialPageSize) {
      pagination = false;
    }
    const sorting = {
      sort: {
        field: 'index',
        direction: 'asc'
      }
    };
    return /*#__PURE__*/_react.default.createElement(_eui.EuiInMemoryTable, {
      css: ccrListingTableStyle,
      columns: [{
        field: 'index',
        name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.ccrListingTable.indexColumnTitle', {
          defaultMessage: 'Index'
        }),
        sortable: true,
        render: (index, {
          shards
        }) => {
          const expanded = !!itemIdToExpandedRowMap[index];
          return /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
            onClick: () => toggleShards(index, shards),
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 223,
              columnNumber: 17
            }
          }, index, "\xA0", expanded ? /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: "arrowUp",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 226,
              columnNumber: 31
            }
          }) : /*#__PURE__*/_react.default.createElement(_eui.EuiIcon, {
            type: "arrowDown",
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 226,
              columnNumber: 60
            }
          }));
        }
      }, {
        field: 'follows',
        sortable: true,
        name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.ccrListingTable.followsColumnTitle', {
          defaultMessage: 'Follows'
        })
      }, {
        field: 'alerts',
        sortable: true,
        name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.ccrListingTable.alertsColumnTitle', {
          defaultMessage: 'Alerts'
        }),
        render: (_field, item) => {
          return /*#__PURE__*/_react.default.createElement(_status.AlertsStatus, {
            showBadge: true,
            alerts: alerts,
            stateFilter: state => state.meta.followerIndex === item.index,
            __self: void 0,
            __source: {
              fileName: _jsxFileName,
              lineNumber: 252,
              columnNumber: 17
            }
          });
        }
      }, {
        field: 'syncLagOps',
        sortable: true,
        name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.ccrListingTable.syncLagOpsColumnTitle', {
          defaultMessage: 'Sync Lag (ops)'
        })
      }, {
        field: 'syncLagTime',
        sortable: true,
        name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.ccrListingTable.lastFetchTimeColumnTitle', {
          defaultMessage: 'Last fetch time'
        }),
        render: syncLagTime => /*#__PURE__*/_react.default.createElement("span", {
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 279,
            columnNumber: 38
          }
        }, toSeconds(syncLagTime))
      }, {
        field: 'opsSynced',
        sortable: true,
        name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.ccrListingTable.opsSyncedColumnTitle', {
          defaultMessage: 'Ops synced'
        })
      }, {
        field: 'error',
        sortable: true,
        name: _i18n.i18n.translate('xpack.monitoring.elasticsearch.ccr.ccrListingTable.errorColumnTitle', {
          defaultMessage: 'Error'
        }),
        render: error => /*#__PURE__*/_react.default.createElement(_eui.EuiTextColor, {
          color: "danger",
          __self: void 0,
          __source: {
            fileName: _jsxFileName,
            lineNumber: 300,
            columnNumber: 32
          }
        }, error)
      }],
      items: items,
      pagination: pagination,
      executeQueryOptions: {
        defaultFields: ['index', 'follows']
      },
      sorting: sorting,
      itemId: "id",
      itemIdToExpandedRowMap: itemIdToExpandedRowMap,
      __self: void 0,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 208,
        columnNumber: 7
      }
    });
  };
  return /*#__PURE__*/_react.default.createElement(_eui.EuiPage, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 316,
      columnNumber: 5
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiPageBody, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 317,
      columnNumber: 7
    }
  }, /*#__PURE__*/_react.default.createElement(_eui.EuiScreenReaderOnly, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 318,
      columnNumber: 9
    }
  }, /*#__PURE__*/_react.default.createElement("h1", {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 319,
      columnNumber: 11
    }
  }, /*#__PURE__*/_react.default.createElement(_i18nReact.FormattedMessage, {
    id: "xpack.monitoring.elasticsearch.ccr.heading",
    defaultMessage: "CCR",
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 320,
      columnNumber: 13
    }
  }))), /*#__PURE__*/_react.default.createElement(_eui.EuiPanel, {
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 326,
      columnNumber: 9
    }
  }, renderTable())));
};
exports.Ccr = Ccr;