"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
var _exportNames = {
  initializeSupportedLanguages: true,
  XJsonLang: true,
  XJSON_LANG_ID: true,
  PainlessLang: true,
  PAINLESS_LANG_ID: true,
  SQLLang: true,
  SQL_LANG_ID: true,
  ESQLLang: true,
  ESQL_LANG_ID: true,
  ESQL_DARK_THEME_ID: true,
  ESQL_LIGHT_THEME_ID: true,
  ESQL_AUTOCOMPLETE_TRIGGER_CHARS: true,
  YamlLang: true,
  YAML_LANG_ID: true,
  configureMonacoYamlSchema: true,
  ConsoleLang: true,
  ConsoleOutputLang: true,
  CONSOLE_LANG_ID: true,
  CONSOLE_OUTPUT_LANG_ID: true,
  CONSOLE_THEME_ID: true,
  CONSOLE_OUTPUT_THEME_ID: true,
  getParsedRequestsProvider: true,
  ConsoleParsedRequestsProvider: true,
  createOutputParser: true,
  MarkdownLang: true,
  MARKDOWN_LANG_ID: true,
  GrokLang: true,
  GROK_LANG_ID: true,
  HandlebarsLang: true,
  HANDLEBARS_LANG_ID: true,
  CssLang: true,
  CSS_LANG_ID: true,
  HJsonLang: true,
  HJSON_LANG_ID: true
};
Object.defineProperty(exports, "CONSOLE_LANG_ID", {
  enumerable: true,
  get: function () {
    return _console.CONSOLE_LANG_ID;
  }
});
Object.defineProperty(exports, "CONSOLE_OUTPUT_LANG_ID", {
  enumerable: true,
  get: function () {
    return _console.CONSOLE_OUTPUT_LANG_ID;
  }
});
Object.defineProperty(exports, "CONSOLE_OUTPUT_THEME_ID", {
  enumerable: true,
  get: function () {
    return _console.CONSOLE_OUTPUT_THEME_ID;
  }
});
Object.defineProperty(exports, "CONSOLE_THEME_ID", {
  enumerable: true,
  get: function () {
    return _console.CONSOLE_THEME_ID;
  }
});
Object.defineProperty(exports, "CSS_LANG_ID", {
  enumerable: true,
  get: function () {
    return _css.CSS_LANG_ID;
  }
});
Object.defineProperty(exports, "ConsoleLang", {
  enumerable: true,
  get: function () {
    return _console.ConsoleLang;
  }
});
Object.defineProperty(exports, "ConsoleOutputLang", {
  enumerable: true,
  get: function () {
    return _console.ConsoleOutputLang;
  }
});
Object.defineProperty(exports, "ConsoleParsedRequestsProvider", {
  enumerable: true,
  get: function () {
    return _console.ConsoleParsedRequestsProvider;
  }
});
Object.defineProperty(exports, "CssLang", {
  enumerable: true,
  get: function () {
    return _css.CssLang;
  }
});
Object.defineProperty(exports, "ESQLLang", {
  enumerable: true,
  get: function () {
    return _esql.ESQLLang;
  }
});
Object.defineProperty(exports, "ESQL_AUTOCOMPLETE_TRIGGER_CHARS", {
  enumerable: true,
  get: function () {
    return _esql.ESQL_AUTOCOMPLETE_TRIGGER_CHARS;
  }
});
Object.defineProperty(exports, "ESQL_DARK_THEME_ID", {
  enumerable: true,
  get: function () {
    return _esql.ESQL_DARK_THEME_ID;
  }
});
Object.defineProperty(exports, "ESQL_LANG_ID", {
  enumerable: true,
  get: function () {
    return _esql.ESQL_LANG_ID;
  }
});
Object.defineProperty(exports, "ESQL_LIGHT_THEME_ID", {
  enumerable: true,
  get: function () {
    return _esql.ESQL_LIGHT_THEME_ID;
  }
});
Object.defineProperty(exports, "GROK_LANG_ID", {
  enumerable: true,
  get: function () {
    return _grok.GROK_LANG_ID;
  }
});
Object.defineProperty(exports, "GrokLang", {
  enumerable: true,
  get: function () {
    return _grok.GrokLang;
  }
});
Object.defineProperty(exports, "HANDLEBARS_LANG_ID", {
  enumerable: true,
  get: function () {
    return _handlebars.HANDLEBARS_LANG_ID;
  }
});
Object.defineProperty(exports, "HJSON_LANG_ID", {
  enumerable: true,
  get: function () {
    return _hjson.HJSON_LANG_ID;
  }
});
Object.defineProperty(exports, "HJsonLang", {
  enumerable: true,
  get: function () {
    return _hjson.HJsonLang;
  }
});
Object.defineProperty(exports, "HandlebarsLang", {
  enumerable: true,
  get: function () {
    return _handlebars.HandlebarsLang;
  }
});
Object.defineProperty(exports, "MARKDOWN_LANG_ID", {
  enumerable: true,
  get: function () {
    return _markdown.MARKDOWN_LANG_ID;
  }
});
Object.defineProperty(exports, "MarkdownLang", {
  enumerable: true,
  get: function () {
    return _markdown.MarkdownLang;
  }
});
Object.defineProperty(exports, "PAINLESS_LANG_ID", {
  enumerable: true,
  get: function () {
    return _painless.PAINLESS_LANG_ID;
  }
});
Object.defineProperty(exports, "PainlessLang", {
  enumerable: true,
  get: function () {
    return _painless.PainlessLang;
  }
});
Object.defineProperty(exports, "SQLLang", {
  enumerable: true,
  get: function () {
    return _sql.SQLLang;
  }
});
Object.defineProperty(exports, "SQL_LANG_ID", {
  enumerable: true,
  get: function () {
    return _sql.SQL_LANG_ID;
  }
});
Object.defineProperty(exports, "XJSON_LANG_ID", {
  enumerable: true,
  get: function () {
    return _xjson.XJSON_LANG_ID;
  }
});
Object.defineProperty(exports, "XJsonLang", {
  enumerable: true,
  get: function () {
    return _xjson.XJsonLang;
  }
});
Object.defineProperty(exports, "YAML_LANG_ID", {
  enumerable: true,
  get: function () {
    return _yaml.YAML_LANG_ID;
  }
});
Object.defineProperty(exports, "YamlLang", {
  enumerable: true,
  get: function () {
    return _yaml.YamlLang;
  }
});
Object.defineProperty(exports, "configureMonacoYamlSchema", {
  enumerable: true,
  get: function () {
    return _yaml.configureMonacoYamlSchema;
  }
});
Object.defineProperty(exports, "createOutputParser", {
  enumerable: true,
  get: function () {
    return _console.createOutputParser;
  }
});
Object.defineProperty(exports, "getParsedRequestsProvider", {
  enumerable: true,
  get: function () {
    return _console.getParsedRequestsProvider;
  }
});
exports.initializeSupportedLanguages = void 0;
var _helpers = require("../helpers");
var _xjson = require("./xjson");
var _painless = require("./painless");
Object.keys(_painless).forEach(function (key) {
  if (key === "default" || key === "__esModule") return;
  if (Object.prototype.hasOwnProperty.call(_exportNames, key)) return;
  if (key in exports && exports[key] === _painless[key]) return;
  Object.defineProperty(exports, key, {
    enumerable: true,
    get: function () {
      return _painless[key];
    }
  });
});
var _sql = require("./sql");
var _esql = require("./esql");
var _yaml = require("./yaml");
var _console = require("./console");
var _markdown = require("./markdown");
var _grok = require("./grok");
var _handlebars = require("./handlebars");
var _css = require("./css");
var _hjson = require("./hjson");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the "Elastic License
 * 2.0", the "GNU Affero General Public License v3.0 only", and the "Server Side
 * Public License v 1"; you may not use this file except in compliance with, at
 * your election, the "Elastic License 2.0", the "GNU Affero General Public
 * License v3.0 only", or the "Server Side Public License, v 1".
 */

// export all language ids

// export all language definitions

const initializeSupportedLanguages = () => {
  [_xjson.XJsonLang, _painless.PainlessLang, _sql.SQLLang, _esql.ESQLLang, _yaml.YamlLang, _console.ConsoleLang, _console.ConsoleOutputLang, _markdown.MarkdownLang, _grok.GrokLang, _handlebars.HandlebarsLang, _css.CssLang, _hjson.HJsonLang].forEach(lang => (0, _helpers.registerLanguage)(lang));
};
exports.initializeSupportedLanguages = initializeSupportedLanguages;