"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.MlManagementLocatorInternal = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _constants = require("@kbn/deeplinks-management/constants");
var _locator = require("../../common/constants/locator");
var _formatters = require("./formatters");
var _trained_models = require("./formatters/trained_models");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

/**
 * This class is meant as a wrapper for the Management Locator.
 * This will ensure url formatting is consistent with what it was prior to being moved to the Management section.
 */
class MlManagementLocatorInternal {
  constructor(share) {
    (0, _defineProperty2.default)(this, "_locator", void 0);
    (0, _defineProperty2.default)(this, "_sectionId", 'ml');
    (0, _defineProperty2.default)(this, "validPaths", new Set(Object.values(_locator.ML_PAGES)));
    (0, _defineProperty2.default)(this, "getPath", (params, appId) => {
      let path = '';
      if ((params === null || params === void 0 ? void 0 : params.page) === undefined) return path;
      if (!this.validPaths.has(params.page)) {
        throw new Error('Page type is not provided or unknown');
      }
      switch (params.page) {
        //  This case covers ML_PAGES.ANOMALY_DETECTION_JOBS_MANAGE || ML_PAGES.DATA_FRAME_ANALYTICS_JOBS_MANAGE as they are empty strings.
        //  This is because they are each the root page for their respective sections/apps in Stack Management > Machine Learning
        case '':
          if (appId === 'anomaly_detection') {
            path = (0, _formatters.formatAnomalyDetectionJobManagementUrl)('', params.pageState);
          } else if (appId === 'analytics') {
            path = (0, _formatters.formatDataFrameAnalyticsJobManagementUrl)('', params.pageState);
          }
          break;
        case _locator.ML_PAGES.TRAINED_MODELS_MANAGE:
          path = (0, _trained_models.formatTrainedModelsManagementUrl)('', params.pageState);
          break;
        case _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_SELECT_TYPE:
          path = (0, _formatters.formatAnomalyDetectionCreateJobSelectType)('', params.pageState);
          break;
        case _locator.ML_PAGES.ANOMALY_DETECTION_CREATE_JOB_SELECT_INDEX:
          path = (0, _formatters.formatAnomalyDetectionCreateJobSelectIndex)('', params.pageState);
          break;
        case _locator.ML_PAGES.DATA_FRAME_ANALYTICS_CREATE_JOB:
          path = (0, _formatters.formatDataFrameAnalyticsCreateJobUrl)('', params.pageState);
          break;
        case _locator.ML_PAGES.FILTER_LISTS_EDIT:
          path = (0, _formatters.formatEditFilterUrl)('', params.pageState);
          break;
        case _locator.ML_PAGES.CALENDARS_EDIT:
          path = (0, _formatters.formatEditCalendarUrl)('', params.pageState);
          break;
        case _locator.ML_PAGES.CALENDARS_DST_EDIT:
          path = (0, _formatters.formatEditCalendarDstUrl)('', params.pageState);
          break;
        default:
          path = (0, _formatters.formatGenericMlUrl)('', params.page, params.pageState);
          break;
      }
      return path;
    });
    (0, _defineProperty2.default)(this, "getUrl", async (params, appId = 'anomaly_detection') => {
      var _this$_locator;
      const path = params ? this.getPath(params, appId) : '';
      const url = await ((_this$_locator = this._locator) === null || _this$_locator === void 0 ? void 0 : _this$_locator.getUrl({
        sectionId: this._sectionId,
        appId: `${appId}${path}`
      }));
      return {
        path,
        url
      };
    });
    (0, _defineProperty2.default)(this, "getRedirectUrl", (params, appId = 'anomaly_detection') => {
      var _this$_locator2;
      const path = this.getPath(params, appId);
      const url = (_this$_locator2 = this._locator) === null || _this$_locator2 === void 0 ? void 0 : _this$_locator2.getRedirectUrl({
        sectionId: this._sectionId,
        appId: `${appId}/${path}`
      });
      return {
        path,
        url
      };
    });
    (0, _defineProperty2.default)(this, "navigate", async (path, appId = 'anomaly_detection') => {
      var _this$_locator3;
      await ((_this$_locator3 = this._locator) === null || _this$_locator3 === void 0 ? void 0 : _this$_locator3.navigate({
        sectionId: this._sectionId,
        appId: `${appId}/${path}`
      }));
    });
    this._locator = share.url.locators.get(_constants.MANAGEMENT_APP_LOCATOR);
  }
}
exports.MlManagementLocatorInternal = MlManagementLocatorInternal;