"use strict";

Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.useExplorerUrlState = useExplorerUrlState;
var _react = require("react");
var _mlUrlState = require("@kbn/ml-url-state");
var _severity_format_resolver = require("../../components/controls/select_severity/severity_format_resolver");
var _locator = require("../../../../common/constants/locator");
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */

function useExplorerUrlState() {
  /**
   * Originally `mlExplorerSwimlane` resided directly in the app URL state (`_a` URL state key).
   * With current URL structure it has been moved under the `explorer` key of the app state (_a).
   */
  const [legacyExplorerState] = (0, _mlUrlState.usePageUrlState)('mlExplorerSwimlane');
  const [rawExplorerState, setExplorerState, explorerStateService] = (0, _mlUrlState.usePageUrlState)(_locator.ML_PAGES.ANOMALY_EXPLORER, {
    mlExplorerSwimlane: legacyExplorerState,
    mlExplorerFilter: {}
  });
  const explorerState = (0, _react.useMemo)(() => {
    const swimlaneState = rawExplorerState.mlExplorerSwimlane;

    // Check specifically for the old format (number type)
    if (swimlaneState && typeof swimlaneState.severity === 'number') {
      // Use the resolver function to handle old format conversion
      const resolvedSeverity = (0, _severity_format_resolver.resolveSeverityFormat)(swimlaneState.severity);
      return {
        ...rawExplorerState,
        mlExplorerSwimlane: {
          ...swimlaneState,
          severity: resolvedSeverity
        }
      };
    }

    // Return the original state if no conversion was needed
    return rawExplorerState;
  }, [rawExplorerState]);
  return [explorerState, setExplorerState, explorerStateService];
}