"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.FeedBackButton = void 0;
var _react = _interopRequireWildcard(require("react"));
var _useMountedState = _interopRequireDefault(require("react-use/lib/useMountedState"));
var _locator = require("../../../locator");
var _kibana = require("../../contexts/kibana");
var _ml = require("../../contexts/ml");
var _jobs = require("../../services/ml_api_service/jobs");
var _hooks = require("../node_available_warning/hooks");
var _feature_feedback_button = require("./feature_feedback_button");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/ml/public/application/components/feedback_button/feedback_button.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
const FORM_IDS = {
  SINGLE_METRIC_VIEWER: '1FAIpQLSdlMYe3wuJh2KtBLajI4EVoUljAhGjJwjZI7zUY_Kn_Sr2lug',
  ANOMALY_EXPLORER: '1FAIpQLSfF1Ry561b4lYrY7iiyXhuZpxFzAmy2c9BFUT3J2AJUevY1iw'
};
const MATCHED_CREATED_BY_TAGS = ['ml-module-metrics-ui-hosts'];
const FeedBackButton = ({
  jobIds,
  page
}) => {
  const {
    jobs: getJobs
  } = (0, _jobs.useJobsApiService)();
  const {
    services: {
      kibanaVersion
    }
  } = (0, _kibana.useMlKibana)();
  const {
    isCloud
  } = (0, _hooks.useCloudCheck)();
  // ML does not have an explicit isServerless flag,
  // it does however have individual feature flags which are set depending
  // whether the environment is serverless or not.
  // showNodeInfo will always be false in a serverless environment
  // and true in a non-serverless environment.
  const {
    showNodeInfo
  } = (0, _ml.useEnabledFeatures)();
  const [jobIdsString, setJobIdsString] = (0, _react.useState)(null);
  const [showButton, setShowButton] = (0, _react.useState)(false);
  const formId = (0, _react.useMemo)(() => getFormId(page), [page]);
  const isMounted = (0, _useMountedState.default)();
  (0, _react.useEffect)(() => {
    const tempJobIdsString = jobIds.join(',');
    if (tempJobIdsString === jobIdsString || tempJobIdsString === '') {
      return;
    }
    setShowButton(false);
    setJobIdsString(tempJobIdsString);
    getJobs(jobIds).then(resp => {
      if (isMounted()) {
        setShowButton(resp.some(job => {
          var _job$custom_settings;
          return MATCHED_CREATED_BY_TAGS.includes((_job$custom_settings = job.custom_settings) === null || _job$custom_settings === void 0 ? void 0 : _job$custom_settings.created_by);
        }));
      }
    });
  }, [jobIds, getJobs, jobIdsString, isMounted]);
  if (showButton === false || formId === null) {
    return null;
  }
  return /*#__PURE__*/_react.default.createElement(_feature_feedback_button.FeatureFeedbackButton, {
    "data-test-subj": "mlFeatureFeedbackButton",
    formUrl: getFormUrl(formId),
    kibanaVersion: kibanaVersion,
    isCloudEnv: isCloud,
    isServerlessEnv: showNodeInfo === false,
    __self: void 0,
    __source: {
      fileName: _jsxFileName,
      lineNumber: 73,
      columnNumber: 5
    }
  });
};
exports.FeedBackButton = FeedBackButton;
function getFormId(page) {
  switch (page) {
    case _locator.ML_PAGES.SINGLE_METRIC_VIEWER:
      return FORM_IDS.SINGLE_METRIC_VIEWER;
    case _locator.ML_PAGES.ANOMALY_EXPLORER:
      return FORM_IDS.ANOMALY_EXPLORER;
    default:
      return null;
  }
}
function getFormUrl(formId) {
  return `https://docs.google.com/forms/d/e/${formId}/viewform?usp=pp_url`;
}