"use strict";

var _interopRequireDefault = require("@babel/runtime/helpers/interopRequireDefault");
Object.defineProperty(exports, "__esModule", {
  value: true
});
exports.AttributionControl = void 0;
var _defineProperty2 = _interopRequireDefault(require("@babel/runtime/helpers/defineProperty"));
var _react = _interopRequireWildcard(require("react"));
var _lodash = _interopRequireDefault(require("lodash"));
var _eui = require("@elastic/eui");
var _classnames = _interopRequireDefault(require("classnames"));
var _kibana_services = require("../../../kibana_services");
var _jsxFileName = "/opt/buildkite-agent/builds/bk-agent-prod-gcp-1761217393098533176/elastic/kibana-artifacts-snapshot/kibana/x-pack/platform/plugins/shared/maps/public/connected_components/right_side_controls/attribution_control/attribution_control.tsx";
/*
 * Copyright Elasticsearch B.V. and/or licensed to Elasticsearch B.V. under one
 * or more contributor license agreements. Licensed under the Elastic License
 * 2.0; you may not use this file except in compliance with the Elastic License
 * 2.0.
 */
function _getRequireWildcardCache(e) { if ("function" != typeof WeakMap) return null; var r = new WeakMap(), t = new WeakMap(); return (_getRequireWildcardCache = function (e) { return e ? t : r; })(e); }
function _interopRequireWildcard(e, r) { if (!r && e && e.__esModule) return e; if (null === e || "object" != typeof e && "function" != typeof e) return { default: e }; var t = _getRequireWildcardCache(r); if (t && t.has(e)) return t.get(e); var n = { __proto__: null }, a = Object.defineProperty && Object.getOwnPropertyDescriptor; for (var u in e) if ("default" !== u && {}.hasOwnProperty.call(e, u)) { var i = a ? Object.getOwnPropertyDescriptor(e, u) : null; i && (i.get || i.set) ? Object.defineProperty(n, u, i) : n[u] = e[u]; } return n.default = e, t && t.set(e, n), n; }
class AttributionControl extends _react.Component {
  constructor(...args) {
    super(...args);
    (0, _defineProperty2.default)(this, "_isMounted", false);
    (0, _defineProperty2.default)(this, "state", {
      uniqueAttributions: []
    });
    (0, _defineProperty2.default)(this, "_loadAttributions", async () => {
      const attributionPromises = this.props.layerList.map(async layer => {
        try {
          return await layer.getAttributions();
        } catch (error) {
          return [];
        }
      });
      const attributions = await Promise.all(attributionPromises);
      if (!this._isMounted) {
        return;
      }
      const uniqueAttributions = [];
      for (let i = 0; i < attributions.length; i++) {
        for (let j = 0; j < attributions[i].length; j++) {
          const testAttr = attributions[i][j];
          const attr = uniqueAttributions.find(added => {
            return added.url === testAttr.url && added.label === testAttr.label;
          });
          if (!attr) {
            uniqueAttributions.push(testAttr);
          }
        }
      }

      // Reflect top-to-bottom layer order as left-to-right in attribs
      uniqueAttributions.reverse();
      if (!_lodash.default.isEqual(this.state.uniqueAttributions, uniqueAttributions)) {
        this.setState({
          uniqueAttributions
        });
      }
    });
  }
  componentDidMount() {
    this._isMounted = true;
    this._loadAttributions();
  }
  componentWillUnmount() {
    this._isMounted = false;
  }
  componentDidUpdate() {
    this._loadAttributions();
  }
  _renderAttribution({
    url,
    label
  }) {
    return !url || (0, _kibana_services.isScreenshotMode)() ? label : /*#__PURE__*/_react.default.createElement(_eui.EuiLink, {
      color: "text",
      href: url,
      target: "_blank",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 81,
        columnNumber: 7
      }
    }, label);
  }
  _renderAttributions() {
    return this.state.uniqueAttributions.map((attribution, index) => {
      return /*#__PURE__*/_react.default.createElement(_react.Fragment, {
        key: index,
        __self: this,
        __source: {
          fileName: _jsxFileName,
          lineNumber: 90,
          columnNumber: 9
        }
      }, this._renderAttribution(attribution), index < this.state.uniqueAttributions.length - 1 && ', ');
    });
  }
  render() {
    if (this.state.uniqueAttributions.length === 0) {
      return null;
    }
    return /*#__PURE__*/_react.default.createElement("div", {
      className: (0, _classnames.default)('mapAttributionControl', {
        // eslint-disable-next-line @typescript-eslint/naming-convention
        mapAttributionControl__fullScreen: this.props.isFullScreen
      }),
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 103,
        columnNumber: 7
      }
    }, /*#__PURE__*/_react.default.createElement(_eui.EuiText, {
      size: "xs",
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 109,
        columnNumber: 9
      }
    }, /*#__PURE__*/_react.default.createElement("small", {
      __self: this,
      __source: {
        fileName: _jsxFileName,
        lineNumber: 110,
        columnNumber: 11
      }
    }, this._renderAttributions())));
  }
}
exports.AttributionControl = AttributionControl;